/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.configs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class GSConfigEnergy {
    public static boolean loaded;
    public static Configuration config;
    public static float coefficientFuelGenerator;
    public static float coefficientThermodynamicGenerator;
    public static float coefficientSolarWindPanel;
    public static float coefficientSolarPanel;
    public static float coefficientWindTurbine;
    public static float coefficientSpeedRocketAssembly;

    public GSConfigEnergy(File file) {
        if (!loaded) {
            config = new Configuration(file);
            GSConfigEnergy.syncConfig(true);
        }
    }

    public static void syncConfig(boolean load) {
        ArrayList<String> propOrder = new ArrayList<String>();
        try {
            if (!GSConfigEnergy.config.isChild && load) {
                config.load();
            }
            Property prop = config.get("general", "coefficientFuelGenerator", (double)coefficientFuelGenerator);
            prop.setComment("Fuel Generator power factor");
            prop.setLanguageKey("gc.configgui.coefficientFuelGenerator").setRequiresMcRestart(false);
            coefficientFuelGenerator = (float)prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientThermodynamicGenerator", (double)coefficientThermodynamicGenerator);
            prop.setComment("Thermodynamic Generator power factor");
            prop.setLanguageKey("gc.configgui.coefficientThermodynamicGenerator").setRequiresMcRestart(false);
            coefficientThermodynamicGenerator = (float)prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientSolarWindPanel", (double)coefficientSolarWindPanel);
            prop.setComment("Solar Wind Panel power factor");
            prop.setLanguageKey("gc.configgui.coefficientSolarWindPanel").setRequiresMcRestart(false);
            coefficientSolarWindPanel = (float)prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientSolarPanel", (double)coefficientSolarPanel);
            prop.setComment("Gybrid Solar Panel power factor");
            prop.setLanguageKey("gc.configgui.coefficientSolarPanel").setRequiresMcRestart(false);
            coefficientSolarPanel = (float)prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientWindTurbine", (double)coefficientWindTurbine);
            prop.setComment("Wind Turbine power factor");
            prop.setLanguageKey("gc.configgui.coefficientWindTurbine").setRequiresMcRestart(false);
            coefficientWindTurbine = (float)prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientSpeedRocketAssembly", (double)coefficientSpeedRocketAssembly);
            prop.setComment("Rocket Assembly craft speed factor");
            prop.setLanguageKey("gc.configgui.coefficientSpeedRocketAssembly").setRequiresMcRestart(false);
            coefficientSpeedRocketAssembly = (float)prop.getDouble();
            propOrder.add(prop.getName());
            config.setCategoryPropertyOrder("general", propOrder);
            if (config.hasChanged()) {
                config.save();
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"GalaxySpace (Energy) has a problem loading it's config", (Object[])new Object[0]);
        }
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("difficulty")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("general")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("client")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("controls")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("compatibility")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("worldgen")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("server")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("dimensions")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("schematic")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("achievements")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("entities")).getChildElements());
        return list;
    }

    static {
        coefficientFuelGenerator = 1.0f;
        coefficientThermodynamicGenerator = 1.0f;
        coefficientSolarWindPanel = 1.0f;
        coefficientSolarPanel = 1.0f;
        coefficientWindTurbine = 1.0f;
        coefficientSpeedRocketAssembly = 1.0f;
    }
}

