/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyUtils {
    public static int distribute(int amount, Collection<IEnergyStorage> receivers) {
        int remainingEnergy = amount;
        HashSet<IEnergyStorage> remainingReceivers = new HashSet<IEnergyStorage>(receivers);
        while (remainingEnergy > 0 && !remainingReceivers.isEmpty()) {
            int energyAtStartOfIteration = remainingEnergy;
            int portionPerReceiver = remainingEnergy / remainingReceivers.size();
            Iterator iter = remainingReceivers.iterator();
            while (iter.hasNext()) {
                IEnergyStorage receiver = (IEnergyStorage)iter.next();
                if (!receiver.canReceive()) {
                    iter.remove();
                    continue;
                }
                int transferred = receiver.receiveEnergy(portionPerReceiver, false);
                remainingEnergy -= transferred;
                if (transferred < portionPerReceiver) continue;
                iter.remove();
            }
            if (remainingEnergy < energyAtStartOfIteration) continue;
            break;
        }
        return Math.min(amount - remainingEnergy, amount);
    }

    public static IEnergyStorage restrict(IEnergyStorage storage, int insertLimit, int extractLimit) {
        return new RatedEnergyStorage(storage, insertLimit, extractLimit);
    }

    public static IEnergyStorage join(IEnergyStorage ... storages) {
        return EnergyUtils.join(Arrays.asList(storages));
    }

    public static IEnergyStorage join(List<? extends IEnergyStorage> storages) {
        return new CascadingEnergyStorage(storages);
    }

    private static class CascadingEnergyStorage
    implements IEnergyStorage {
        private final List<? extends IEnergyStorage> delegates;

        public CascadingEnergyStorage(List<? extends IEnergyStorage> delegates) {
            this.delegates = delegates;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int remaining = maxReceive;
            for (IEnergyStorage iEnergyStorage : this.delegates) {
                if ((remaining -= iEnergyStorage.receiveEnergy(remaining, simulate)) > 0) continue;
                return maxReceive;
            }
            return Math.min(maxReceive - remaining, maxReceive);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int remaining = maxExtract;
            for (IEnergyStorage iEnergyStorage : this.delegates) {
                if ((remaining -= iEnergyStorage.extractEnergy(remaining, simulate)) > 0) continue;
                return maxExtract;
            }
            return Math.min(maxExtract - remaining, maxExtract);
        }

        public int getEnergyStored() {
            return this.delegates.stream().mapToInt(IEnergyStorage::getEnergyStored).sum();
        }

        public int getMaxEnergyStored() {
            return this.delegates.stream().mapToInt(IEnergyStorage::getMaxEnergyStored).sum();
        }

        public boolean canExtract() {
            return this.delegates.stream().anyMatch(IEnergyStorage::canExtract);
        }

        public boolean canReceive() {
            return this.delegates.stream().anyMatch(IEnergyStorage::canReceive);
        }
    }

    private static class RatedEnergyStorage
    implements IEnergyStorage {
        private final IEnergyStorage delegate;
        private final int insertLimit;
        private final int extractLimit;

        public RatedEnergyStorage(IEnergyStorage delegate, int insertLimit, int extractLimit) {
            this.delegate = delegate;
            this.insertLimit = insertLimit;
            this.extractLimit = extractLimit;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return this.delegate.receiveEnergy(Math.min(maxReceive, this.insertLimit), simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return this.delegate.extractEnergy(Math.min(maxExtract, this.extractLimit), simulate);
        }

        public int getEnergyStored() {
            return this.delegate.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return this.delegate.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return this.extractLimit > 0 && this.delegate.canExtract();
        }

        public boolean canReceive() {
            return this.insertLimit > 0 && this.delegate.canReceive();
        }
    }
}

