/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.render.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;

public class BakedQuadList {
    private final List<BakedQuad> unsidedQuads = new ArrayList<BakedQuad>();
    private final EnumMap<EnumFacing, List<BakedQuad>> sidedQuads = new EnumMap(EnumFacing.class);

    public void addQuad(@Nullable EnumFacing face, BakedQuad quad) {
        if (face == null) {
            this.unsidedQuads.add(quad);
        } else {
            this.getOrCreateSidedList(face).add(quad);
        }
    }

    public void addQuads(@Nullable EnumFacing face, Iterator<BakedQuad> quads) {
        if (face == null) {
            while (quads.hasNext()) {
                this.unsidedQuads.add(quads.next());
            }
        } else {
            List<BakedQuad> sidedQuadList = this.getOrCreateSidedList(face);
            while (quads.hasNext()) {
                sidedQuadList.add(quads.next());
            }
        }
    }

    public void addQuads(@Nullable EnumFacing face, Collection<BakedQuad> quads) {
        if (face == null) {
            this.unsidedQuads.addAll(quads);
        } else {
            this.getOrCreateSidedList(face).addAll(quads);
        }
    }

    private List<BakedQuad> getOrCreateSidedList(EnumFacing face) {
        return this.sidedQuads.computeIfAbsent(face, k -> new ArrayList());
    }

    public List<BakedQuad> getQuads(@Nullable EnumFacing face) {
        if (face == null) {
            return this.unsidedQuads;
        }
        List<BakedQuad> quads = this.sidedQuads.get(face);
        return quads != null ? quads : Collections.emptyList();
    }
}

