/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.event;

import java.util.UUID;
import micdoodle8.mods.galacticraft.api.event.oxygen.GCCoreOxygenSuffocationEvent;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntityJuicer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.core.dimension.WorldProviderSpaceNether;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.init.MPPotions;
import stevekung.mods.moreplanets.moons.koentus.entity.EntityKoentusMeteor;
import stevekung.mods.moreplanets.planets.diona.entity.EntityZeliusZombie;
import stevekung.mods.moreplanets.planets.nibiru.dimension.WorldProviderNibiru;
import stevekung.mods.moreplanets.planets.nibiru.entity.EntityInfectedZombie;
import stevekung.mods.moreplanets.planets.nibiru.entity.EntityShlime;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.biome.BiomeGreenVeinFields;
import stevekung.mods.moreplanets.tileentity.TileEntityShieldGenerator;
import stevekung.mods.moreplanets.utils.CompatibilityManagerMP;
import stevekung.mods.moreplanets.utils.EntityEffectUtils;
import stevekung.mods.moreplanets.utils.LoggerMP;
import stevekung.mods.moreplanets.world.IMeteorType;

public class EntityEventHandler {
    @SubscribeEvent
    public void onZombieSummonAid(ZombieEvent.SummonAidEvent event) {
        EntityZombie zombie;
        if (event.getEntity() instanceof EntityInfectedZombie) {
            zombie = new EntityInfectedZombie(event.getWorld());
            event.setCustomSummonedAid(zombie);
            if ((double)zombie.func_70681_au().nextFloat() < zombie.func_110148_a(zombie.getReinforcementsAttribute()).func_111126_e()) {
                event.setResult(Event.Result.ALLOW);
            }
            event.setResult(Event.Result.DENY);
        }
        if (event.getEntity() instanceof EntityZeliusZombie) {
            zombie = new EntityZeliusZombie(event.getWorld());
            event.setCustomSummonedAid(zombie);
            if ((double)zombie.func_70681_au().nextFloat() < zombie.func_110148_a(zombie.getReinforcementsAttribute()).func_111126_e()) {
                event.setResult(Event.Result.ALLOW);
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        EntityLivingBase living;
        if (!CompatibilityManagerMP.isBaubleLoaded && (living = event.getEntityLiving()) instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)living;
            if (player.field_71071_by.func_70431_c(new ItemStack(MPItems.GRAVITY_AMULET))) {
                event.setCanceled(true);
            } else {
                event.setCanceled(false);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        World world = living.field_70170_p;
        if (living instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)living;
            if (player.func_70644_a(MPPotions.INFECTED_SPORE_PROTECTION) || this.isInOxygen(world, (EntityPlayer)player)) {
                player.func_184589_d(MPPotions.INFECTED_SPORE);
            }
            if (player.func_70644_a(MPPotions.DARK_ENERGY_PROTECTION)) {
                player.func_184589_d(MPPotions.DARK_ENERGY);
            }
            if (world.field_73011_w instanceof WorldProviderNibiru && !this.isGodPlayer((EntityPlayer)player) && !player.func_70644_a(MPPotions.INFECTED_SPORE_PROTECTION) && !(world.func_180494_b(player.func_180425_c()) instanceof BiomeGreenVeinFields)) {
                if (world.func_175727_C(player.func_180425_c())) {
                    player.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 40));
                }
                if (player.field_70173_aa % 128 == 0 && !this.isInOxygen(world, (EntityPlayer)player)) {
                    player.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 80));
                }
            }
            if (!world.field_72995_K && world.field_73011_w instanceof IMeteorType) {
                this.spawnMeteors(world, player, (IMeteorType)world.field_73011_w);
            }
        } else if (ConfigManagerMP.moreplanets_planet_settings.enableInfectedSporeForMobs && world.field_73011_w instanceof WorldProviderNibiru && !EntityEffectUtils.isGalacticraftMob((Entity)living) && !(living instanceof EntityJuicer) && !(world.func_180494_b(living.func_180425_c()) instanceof BiomeGreenVeinFields)) {
            if (living.field_70173_aa % 128 == 0) {
                living.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 80));
            } else if (world.func_175727_C(living.func_180425_c())) {
                living.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 40));
            }
        }
        if (living instanceof IMob) {
            for (BlockVec3Dim vec : TileEntityShieldGenerator.LOADED_GENERATORS) {
                UUID uuid;
                TileEntity tile;
                if (vec == null || vec.dim != GCCoreUtil.getDimensionID((World)world) || !((tile = vec.getTileEntity()) instanceof TileEntityShieldGenerator)) continue;
                TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
                if (living.field_70170_p.field_72995_K || living.field_70128_L || !shield.isInsideShield(living.func_180425_c()) || shield.disabled || !shield.enableShield || shield.shieldCapacity <= 0) continue;
                if (!shield.enableDamage) {
                    double d13;
                    double d4 = living.func_70011_f((double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p());
                    double d6 = living.field_70165_t - (double)tile.func_174877_v().func_177958_n();
                    double d8 = living.field_70163_u - (double)tile.func_174877_v().func_177956_o();
                    double d10 = living.field_70161_v - (double)tile.func_174877_v().func_177952_p();
                    double d11 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8 + d10 * d10));
                    double d14 = d13 = (0.0 - d4) * 2.0 / 10.0;
                    double knockback = 10.0;
                    living.field_70159_w -= (d6 /= d11) * d14 / knockback;
                    living.field_70181_x -= (d8 /= d11) * d14 / knockback;
                    living.field_70179_y -= (d10 /= d11) * d14 / knockback;
                }
                try {
                    uuid = UUID.fromString(shield.ownerUUID);
                }
                catch (Exception e) {
                    uuid = UUID.fromString("eef3a603-1c1b-4c98-8264-d2f04b231ef4");
                }
                if (living.field_70170_p.func_152378_a(uuid) != null) {
                    if (living.field_70173_aa % 8 == 0) {
                        ((WorldServer)living.field_70170_p).func_175739_a(EnumParticleTypes.CRIT_MAGIC, living.field_70165_t, living.field_70163_u, living.field_70161_v, 20, 0.0, 0.5, 0.0, 1.0, new int[0]);
                    }
                    if (shield.enableDamage) {
                        living.func_70097_a(DamageSource.func_76365_a((EntityPlayer)living.field_70170_p.func_152378_a(uuid)), (float)shield.shieldDamage);
                    }
                } else {
                    if (living.field_70173_aa % 8 == 0) {
                        ((WorldServer)living.field_70170_p).func_175739_a(EnumParticleTypes.CRIT_MAGIC, living.field_70165_t, living.field_70163_u, living.field_70161_v, 20, 0.0, 0.5, 0.0, 1.0, new int[0]);
                    }
                    if (shield.enableDamage) {
                        living.func_70097_a(DamageSource.field_76377_j, (float)shield.shieldDamage);
                    }
                }
                float motion = MathHelper.func_76133_a((double)(living.field_70159_w * living.field_70159_w + living.field_70179_y * living.field_70179_y));
                shield.shieldCapacity = (int)((float)shield.shieldCapacity - motion * 2.0f);
            }
        }
    }

    @SubscribeEvent
    public void onOxygenSuffocation(GCCoreOxygenSuffocationEvent.Pre event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living.field_70170_p.field_73011_w instanceof WorldProviderSpaceNether && EntityEffectUtils.isSpaceNetherMob((Entity)living)) {
            event.setCanceled(true);
        }
        if (living.field_70170_p.func_180494_b(living.func_180425_c()) instanceof BiomeGreenVeinFields) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onInteractEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack itemStack = event.getItemStack();
        Entity entity = event.getTarget();
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() == Items.field_151100_aR) {
            EnumDyeColor color = EnumDyeColor.func_176766_a((int)(itemStack.func_77952_i() & 0xF));
            if (entity instanceof EntityShlime) {
                EntityShlime shlime = (EntityShlime)entity;
                if (!shlime.getSheared() && shlime.getFleeceColor() != color) {
                    shlime.setFleeceColor(color);
                    if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                        itemStack.func_190918_g(1);
                    }
                }
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(EntityEvent.CanUpdate event) {
        if (event.getEntity() instanceof EntityKoentusMeteor) {
            event.setCanUpdate(true);
            return;
        }
    }

    @SubscribeEvent
    public void onLivingSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.ALLOW || event.isSpawner()) {
            return;
        }
        for (BlockVec3Dim vec : TileEntityShieldGenerator.LOADED_GENERATORS) {
            TileEntity tile;
            if (vec == null || vec.dim != GCCoreUtil.getDimensionID((World)event.getWorld()) || !((tile = vec.getTileEntity()) instanceof TileEntityShieldGenerator)) continue;
            TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
            if (shield.disabled || !shield.isInsideShield(event.getEntityLiving().func_180425_c())) continue;
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        for (BlockVec3Dim vec : TileEntityShieldGenerator.LOADED_GENERATORS) {
            TileEntity tile;
            if (vec == null || vec.dim != GCCoreUtil.getDimensionID((World)event.getEntityLiving().func_130014_f_()) || !((tile = vec.getTileEntity()) instanceof TileEntityShieldGenerator)) continue;
            TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
            if (shield.disabled || !shield.isInsideShield(event.getEntityLiving().func_180425_c())) continue;
            event.setCanceled(true);
        }
    }

    private void spawnMeteors(World world, EntityPlayerMP player, IMeteorType meteor) {
        if (meteor.getMeteorSpawnFrequency() > 0.0 && ConfigManagerCore.meteorSpawnMod > 0.0 && meteor.getMeteorType() != null) {
            EntityKoentusMeteor meteorEntity = null;
            int frequency = (int)(meteor.getMeteorSpawnFrequency() * 750.0 * (1.0 / ConfigManagerCore.meteorSpawnMod));
            int serverDistance = world.func_73046_m().func_184103_al().func_72395_o();
            int x = world.field_73012_v.nextInt(20) + 160;
            int z = world.field_73012_v.nextInt(20) - 10;
            double motX = world.field_73012_v.nextDouble() * 2.0 - 2.5;
            double motZ = world.field_73012_v.nextDouble() * 5.0 - 2.5;
            int px = MathHelper.func_76128_c((double)player.field_70165_t);
            EntityPlayer closestPlayer = world.func_72890_a((Entity)player, 100.0);
            if (closestPlayer == null || closestPlayer.func_145782_y() <= player.func_145782_y()) {
                int size;
                if ((x + px >> 4) - (px >> 4) >= serverDistance) {
                    x = ((px >> 4) + serverDistance << 4) - 1 - px;
                }
                if (world.field_73012_v.nextInt(frequency) == 0) {
                    size = 1 + world.field_73012_v.nextInt(2);
                    switch (meteor.getMeteorType()) {
                        case KOENTUS: {
                            meteorEntity = new EntityKoentusMeteor(world, player.field_70165_t + (double)x, 355.0, player.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, size);
                        }
                    }
                    world.func_72838_d(meteorEntity);
                    LoggerMP.debug("Spawn meteor {} at {} {} {}", EntityList.func_191301_a(meteorEntity), (int)meteorEntity.field_70165_t, (int)meteorEntity.field_70163_u, (int)meteorEntity.field_70161_v);
                }
                if (world.field_73012_v.nextInt(frequency * 3) == 0) {
                    size = 3 + world.field_73012_v.nextInt(6);
                    switch (meteor.getMeteorType()) {
                        case KOENTUS: {
                            meteorEntity = new EntityKoentusMeteor(world, player.field_70165_t + (double)x, 355.0, player.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, size);
                        }
                    }
                    world.func_72838_d(meteorEntity);
                    LoggerMP.debug("Spawn meteor {} at {} {} {}", EntityList.func_191301_a(meteorEntity), (int)meteorEntity.field_70165_t, (int)meteorEntity.field_70163_u, (int)meteorEntity.field_70161_v);
                }
            }
        }
    }

    private boolean isInOxygen(World world, EntityPlayer player) {
        return OxygenUtil.inOxygenBubble((World)world, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v) || OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player);
    }

    private boolean isGodPlayer(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d || player.func_175149_v();
    }
}

