/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.diona.entity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsMod;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.init.MPLootTables;
import stevekung.mods.moreplanets.init.MPPotions;
import stevekung.mods.moreplanets.planets.diona.entity.EntityInfectedPurloniteSlimeMinion;
import stevekung.mods.moreplanets.planets.diona.entity.EntityInfectedPurloniteTentacle;
import stevekung.mods.moreplanets.utils.BossType;
import stevekung.mods.moreplanets.utils.EnumParticleTypesMP;
import stevekung.mods.moreplanets.utils.IMorePlanetsBoss;
import stevekung.mods.moreplanets.utils.entity.EntitySlimeBaseMP;
import stevekung.mods.moreplanets.utils.tileentity.TileEntityTreasureChestMP;
import stevekung.mods.stevekunglib.utils.ColorUtils;
import stevekung.mods.stevekunglib.utils.JsonUtils;
import stevekung.mods.stevekunglib.utils.LangUtils;

public class EntityInfectedPurloniteSlimeBoss
extends EntitySlimeBaseMP
implements IMorePlanetsBoss {
    private TileEntityDungeonSpawner<?> spawner;
    public int deathTicks = 0;
    private int entitiesWithin;
    private int entitiesWithinLast;
    private static final DataParameter<Boolean> BARRIER = EntityDataManager.func_187226_a(EntityInfectedPurloniteSlimeBoss.class, (DataSerializer)DataSerializers.field_187198_h);
    public EntityInfectedPurloniteTentacle tentacle;
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);
    private UUID bossInfoUUID = this.bossInfo.func_186737_d();
    private boolean tentacleSpawning = true;

    public EntityInfectedPurloniteSlimeBoss(World world) {
        super(world);
        if (world.field_72995_K) {
            MorePlanetsMod.PROXY.addBoss(this);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BARRIER, (Object)false);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (((Boolean)this.field_70180_af.func_187225_a(BARRIER)).booleanValue()) {
            nbt.func_74757_a("Barrier", true);
        }
        nbt.func_74757_a("TentacleSpawning", this.tentacleSpawning);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(BARRIER, (Object)nbt.func_74767_n("Barrier"));
        this.tentacleSpawning = nbt.func_74767_n("TentacleSpawning");
    }

    public void func_70653_a(Entity entity, float strength, double xRatio, double zRatio) {
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getDetectRange());
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        if (this.tentacleSpawning) {
            EntityInfectedPurloniteTentacle tentacle1 = new EntityInfectedPurloniteTentacle(this.field_70170_p);
            tentacle1.func_70012_b(this.field_70165_t + 5.0, this.field_70163_u + 2.5, this.field_70161_v + 5.0, 0.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)tentacle1);
            EntityInfectedPurloniteTentacle tentacle2 = new EntityInfectedPurloniteTentacle(this.field_70170_p);
            tentacle2.func_70012_b(this.field_70165_t - 5.0, this.field_70163_u + 2.5, this.field_70161_v - 5.0, 0.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)tentacle2);
            EntityInfectedPurloniteTentacle tentacle3 = new EntityInfectedPurloniteTentacle(this.field_70170_p);
            tentacle3.func_70012_b(this.field_70165_t + 5.0, this.field_70163_u + 2.5, this.field_70161_v - 5.0, 0.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)tentacle3);
            EntityInfectedPurloniteTentacle tentacle4 = new EntityInfectedPurloniteTentacle(this.field_70170_p);
            tentacle4.func_70012_b(this.field_70165_t - 5.0, this.field_70163_u + 2.5, this.field_70161_v + 5.0, 0.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)tentacle4);
            this.tentacleSpawning = false;
        }
        this.setSlimeSize(5, true);
        return data;
    }

    @Override
    public float getSizeBased() {
        return 1.01f;
    }

    protected void func_70609_aI() {
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 2.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks >= 180 && this.deathTicks % 5 == 0) {
                GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_EXPLODE, GCCoreUtil.getDimensionID((World)this.field_70170_p), new Object[0]), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID((World)this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
            }
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0) {
                int j;
                for (int i = 120; i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            if (this.deathTicks == 40) {
                GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_BOSS_DEATH, GCCoreUtil.getDimensionID((World)this.field_70170_p), new Object[]{Float.valueOf(this.func_70647_i() - 0.1f)}), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID((World)this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
            }
        }
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            TileEntity chestTest;
            int j;
            for (int i = 120; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
            TileEntityTreasureChestMP chest = null;
            if (this.spawner != null && this.spawner.getChestPos() != null && (chestTest = this.field_70170_p.func_175625_s(this.spawner.getChestPos())) != null && chestTest instanceof TileEntityTreasureChestMP) {
                chest = (TileEntityTreasureChestMP)chestTest;
            }
            if (chest == null) {
                chest = TileEntityTreasureChestMP.findClosest((Entity)this, MPItems.DIONA_DUNGEON_KEY);
            } else {
                double dist = this.func_70092_e((double)chest.func_174877_v().func_177958_n() + 0.5, (double)chest.func_174877_v().func_177956_o() + 0.5, (double)chest.func_174877_v().func_177952_p() + 0.5);
                if (dist < 1000000.0) {
                    if (!chest.locked) {
                        chest.locked = true;
                    }
                    int slot = this.field_70146_Z.nextInt(chest.func_70302_i_());
                    chest.setLootTable(MPLootTables.COMMON_SPACE_DUNGEON, this.field_70146_Z.nextLong());
                    chest.func_70299_a(slot, MPLootTables.getTieredKey(this.field_70146_Z, 4));
                }
            }
            this.func_70099_a(new ItemStack(MPItems.DIONA_DUNGEON_KEY, 1, 0), 0.5f);
            this.func_70106_y();
            if (this.spawner != null) {
                this.spawner.isBossDefeated = true;
                this.spawner.boss = null;
                this.spawner.spawned = false;
            }
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        List list = this.field_70170_p.func_72872_a(EntityInfectedPurloniteTentacle.class, this.func_174813_aQ().func_186662_g(32.0));
        this.updateTentacle();
        if (list.size() > 0) {
            this.field_70180_af.func_187227_b(BARRIER, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(BARRIER, (Object)false);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return MPLootTables.INFECTED_PURLONITE_SLIME_BOSS;
    }

    public void func_70636_d() {
        if (this.spawner != null) {
            List playersWithin = this.field_70170_p.func_72872_a(EntityPlayer.class, this.spawner.getRangeBounds());
            this.entitiesWithin = playersWithin.size();
            if (this.entitiesWithin == 0 && this.entitiesWithinLast != 0) {
                this.field_70170_p.func_72872_a(EntityPlayer.class, this.spawner.getRangeBoundsPlus11()).forEach(player2 -> player2.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"gui.skeleton_boss.message")).func_150255_a(JsonUtils.red())));
                this.func_70106_y();
                return;
            }
            this.entitiesWithinLast = this.entitiesWithin;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        super.func_70636_d();
    }

    @Override
    public void func_70106_y() {
        int i = this.getSlimeSize();
        if (this.spawner != null) {
            this.spawner.isBossDefeated = false;
            this.spawner.boss = null;
            this.spawner.spawned = false;
        }
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_110143_aJ() <= 0.0f) {
            int j = 8 + this.field_70146_Z.nextInt(8);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                EntityInfectedPurloniteSlimeMinion entityslime = new EntityInfectedPurloniteSlimeMinion(this.field_70170_p);
                if (this.func_145818_k_()) {
                    entityslime.func_96094_a(this.func_95999_t());
                }
                if (this.func_104002_bU()) {
                    entityslime.func_110163_bv();
                }
                entityslime.setSlimeSize(i / 2, true);
                entityslime.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entityslime);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            MorePlanetsMod.PROXY.removeBoss(this);
        }
        this.field_70128_L = true;
    }

    public void func_174812_G() {
        this.func_70606_j(0.0f);
    }

    @Override
    protected void dealDamage(EntityLivingBase entity) {
        if (this.func_70685_l((Entity)entity) && this.func_70068_e((Entity)entity) < this.getDetectRange() && entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getAttackStrength())) {
            this.func_174815_a((EntityLivingBase)this, (Entity)entity);
            entity.func_70690_d(new PotionEffect(MPPotions.INFECTED_PURLONITE, 200, 1));
        }
    }

    @Override
    protected int getAttackStrength() {
        return 12;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187880_fp;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187874_fm;
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if (this.getBarrier() && !damageSource.func_180136_u()) {
            return false;
        }
        if (super.func_70097_a(damageSource, damage)) {
            Entity entity = damageSource.func_76346_g();
            if (this.func_184188_bt().contains(entity) && this.func_184187_bx() != entity) {
                if (entity != this) {
                    this.func_70604_c((EntityLivingBase)entity);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public void onBossSpawned(TileEntityDungeonSpawner spawner) {
        this.spawner = spawner;
    }

    public void func_70690_d(PotionEffect effect) {
    }

    @Override
    protected double getDetectRange() {
        return 512.0;
    }

    @Override
    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(2) + 3;
    }

    @Override
    protected EntitySlimeBaseMP createInstance() {
        return new EntityInfectedPurloniteSlimeBoss(this.field_70170_p);
    }

    @Override
    protected void createParticles() {
        int i = this.getSlimeSize();
        for (int j = 0; j < i * 50; ++j) {
            float f = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.5f;
            float f1 = this.field_70146_Z.nextFloat() * 0.65f + 0.65f;
            float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.65f * f1;
            float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.65f * f1;
            double d0 = this.field_70165_t + (double)f2;
            double d1 = this.field_70161_v + (double)f3;
            MorePlanetsMod.PROXY.spawnParticle(EnumParticleTypesMP.CUSTOM_BREAKING, d0, this.func_174813_aQ().field_72338_b, d1, new Object[]{MPItems.INFECTED_PURLONITE_SLIMEBALL});
        }
    }

    @Override
    protected void overrideHealth() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0 * ConfigManagerCore.dungeonBossHealthMod);
    }

    public void func_184178_b(EntityPlayerMP player) {
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public UUID getBossUUID() {
        return this.bossInfoUUID;
    }

    @Override
    public String getBossName() {
        return this.func_70005_c_();
    }

    @Override
    public BossType getBossType() {
        return BossType.ZELIUS;
    }

    @Override
    public int getBossTextColor() {
        return ColorUtils.rgbToDecimal((int)157, (int)147, (int)183);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeLong(this.bossInfoUUID.getMostSignificantBits());
        buffer.writeLong(this.bossInfoUUID.getLeastSignificantBits());
    }

    @SideOnly(value=Side.CLIENT)
    public void readSpawnData(ByteBuf buffer) {
        long msb = buffer.readLong();
        long lsb = buffer.readLong();
        this.bossInfoUUID = new UUID(msb, lsb);
    }

    public boolean getBarrier() {
        return (Boolean)this.field_70180_af.func_187225_a(BARRIER);
    }

    private void updateTentacle() {
        if (this.tentacle != null && this.tentacle.field_70128_L) {
            this.tentacle = null;
        }
        List list = this.field_70170_p.func_72872_a(EntityInfectedPurloniteTentacle.class, this.func_174813_aQ().func_186662_g(32.0));
        EntityInfectedPurloniteTentacle tentacle = null;
        double distance1 = Double.MAX_VALUE;
        for (EntityInfectedPurloniteTentacle tentacle1 : list) {
            double distance = tentacle1.func_70068_e((Entity)this);
            if (distance < distance1) {
                distance1 = distance;
                tentacle = tentacle1;
            }
            this.tentacle = tentacle;
        }
    }
}

