/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.nibiru.entity;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPLootTables;
import stevekung.mods.moreplanets.init.MPPotions;
import stevekung.mods.moreplanets.planets.diona.entity.EntityAlienMiner;
import stevekung.mods.moreplanets.planets.nibiru.entity.EntityInfectedSquid;
import stevekung.mods.moreplanets.utils.entity.ISpaceMob;

public class EntityInfectedGuardian
extends EntityGuardian
implements ISpaceMob,
IEntityBreathable {
    private static final DataParameter<Boolean> MOVING = EntityDataManager.func_187226_a(EntityInfectedGuardian.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(EntityInfectedGuardian.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityLivingBase targetedEntity;
    private int clientSideAttackTime;

    public EntityInfectedGuardian(World world) {
        super(world);
        this.field_70765_h = new GuardianMoveHelper(this);
    }

    protected void func_184651_r() {
        EntityAIMoveTowardsRestriction entityaimovetowardsrestriction = new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0);
        this.field_175481_bq = new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 80.0f);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIGuardianAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)entityaimovetowardsrestriction);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.field_175481_bq);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityGuardian.class, 12.0f, 0.01f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_175481_bq.func_75248_a(3);
        entityaimovetowardsrestriction.func_75248_a(3);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, (Predicate)new GuardianTargetSelector(this)));
    }

    public boolean func_70687_e(PotionEffect potion) {
        return potion.func_188419_a() == MPPotions.INFECTED_SPORE ? false : super.func_70687_e(potion);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MOVING, (Object)false);
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
    }

    public boolean func_175472_n() {
        return (Boolean)this.field_70180_af.func_187225_a(MOVING);
    }

    public boolean func_175474_cn() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0;
    }

    public EntityLivingBase func_175466_co() {
        if (!this.func_175474_cn()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof EntityLivingBase) {
                this.targetedEntity = (EntityLivingBase)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (TARGET_ENTITY.equals(key)) {
            this.clientSideAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_177230_c() == MPBlocks.INFECTED_WATER_FLUID_BLOCK ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : 0.5f - this.field_70170_p.func_175724_o(pos);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K && this.func_175474_cn()) {
            EntityLivingBase entitylivingbase;
            if (this.clientSideAttackTime < this.func_175464_ck()) {
                ++this.clientSideAttackTime;
            }
            if ((entitylivingbase = this.func_175466_co()) != null) {
                this.func_70671_ap().func_75651_a((Entity)entitylivingbase, 90.0f, 90.0f);
                this.func_70671_ap().func_75649_a();
                double d5 = this.func_175477_p(0.0f);
                double d0 = entitylivingbase.field_70165_t - this.field_70165_t;
                double d1 = entitylivingbase.field_70163_u + (double)(entitylivingbase.field_70131_O * 0.5f) - (this.field_70163_u + (double)this.func_70047_e());
                double d2 = entitylivingbase.field_70161_v - this.field_70161_v;
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d0 /= d3;
                d1 /= d3;
                d2 /= d3;
                double d4 = this.field_70146_Z.nextDouble();
                while (d4 < d3) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + d0 * (d4 += 1.8 - d5 + this.field_70146_Z.nextDouble() * (1.7 - d5)), this.field_70163_u + d1 * d4 + (double)this.func_70047_e(), this.field_70161_v + d2 * d4, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
        super.func_70636_d();
    }

    public float func_175477_p(float partialTicks) {
        return ((float)this.clientSideAttackTime + partialTicks) / (float)this.func_175464_ck();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return MPLootTables.INFECTED_GUARDIAN;
    }

    /*
     * Unable to fully structure code
     */
    public boolean func_70601_bi() {
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL || !this.func_70814_o()) ** GOTO lbl-1000
        v0 = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.func_180484_a(v0) >= 0.0f) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        defaults = v1;
        return (this.field_70146_Z.nextInt(20) == 0 || this.field_70170_p.func_175710_j(new BlockPos((Entity)this)) == false) && defaults != false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.func_175472_n() && !source.func_82725_o() && source.func_76364_f() instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)source.func_76364_f();
            if (!source.func_94541_c()) {
                entitylivingbase.func_70097_a(DamageSource.func_92087_a((Entity)this), 2.0f);
                entitylivingbase.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 80, 0));
            }
        }
        if (this.field_175481_bq != null) {
            this.field_175481_bq.func_179480_f();
        }
        return super.func_70097_a(source, amount);
    }

    public boolean canBreath() {
        return true;
    }

    @Override
    public ISpaceMob.EnumMobType getMobType() {
        return ISpaceMob.EnumMobType.NIBIRU;
    }

    private void setMoving(boolean moving) {
        this.field_70180_af.func_187227_b(MOVING, (Object)moving);
    }

    private void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    static class GuardianTargetSelector
    implements Predicate<EntityLivingBase> {
        private final EntityInfectedGuardian entity;

        public GuardianTargetSelector(EntityInfectedGuardian entity) {
            this.entity = entity;
        }

        public boolean apply(EntityLivingBase entity) {
            return (entity instanceof EntityPlayer || entity instanceof EntityInfectedSquid || entity instanceof EntityAlienMiner) && entity.func_70068_e((Entity)this.entity) > 9.0;
        }
    }

    static class GuardianMoveHelper
    extends EntityMoveHelper {
        private final EntityInfectedGuardian entity;

        public GuardianMoveHelper(EntityInfectedGuardian entity) {
            super((EntityLiving)entity);
            this.entity = entity;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.entity.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.entity.field_70165_t;
                double d1 = this.field_75647_c - this.entity.field_70163_u;
                double d2 = this.field_75644_d - this.entity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = MathHelper.func_76133_a((double)d3);
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 180.0 / Math.PI) - 90.0f;
                this.entity.field_70761_aq = this.entity.field_70177_z = this.func_75639_a(this.entity.field_70177_z, f, 30.0f);
                float f1 = (float)(this.field_75645_e * this.entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.entity.func_70659_e(this.entity.func_70689_ay() + (f1 - this.entity.func_70689_ay()) * 0.125f);
                double d4 = Math.sin((double)(this.entity.field_70173_aa + this.entity.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.entity.field_70177_z * (float)Math.PI / 180.0f);
                double d6 = Math.sin(this.entity.field_70177_z * (float)Math.PI / 180.0f);
                this.entity.field_70159_w += d4 * d5;
                this.entity.field_70179_y += d4 * d6;
                d4 = Math.sin((double)(this.entity.field_70173_aa + this.entity.func_145782_y()) * 0.75) * 0.05;
                this.entity.field_70181_x += d4 * (d6 + d5) * 0.25;
                this.entity.field_70181_x += (double)this.entity.func_70689_ay() * d1 * 0.1;
                EntityLookHelper entitylookhelper = this.entity.func_70671_ap();
                double d7 = this.entity.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.entity.func_70047_e() + this.entity.field_70163_u + d1 / d3 * 1.0;
                double d9 = this.entity.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.func_180423_e();
                double d11 = entitylookhelper.func_180422_f();
                double d12 = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.entity.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
                this.entity.setMoving(true);
            } else {
                this.entity.func_70659_e(0.0f);
                this.entity.setMoving(false);
            }
        }
    }

    static class AIGuardianAttack
    extends EntityAIBase {
        private final EntityInfectedGuardian entity;
        private int tickCounter;

        public AIGuardianAttack(EntityInfectedGuardian entity) {
            this.entity = entity;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entity = this.entity.func_70638_az();
            return entity != null && entity.func_70089_S();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.entity.func_70068_e((Entity)this.entity.func_70638_az()) > 9.0;
        }

        public void func_75249_e() {
            this.tickCounter = -10;
            this.entity.func_70661_as().func_75499_g();
            this.entity.func_70671_ap().func_75651_a((Entity)this.entity.func_70638_az(), 90.0f, 90.0f);
            this.entity.field_70160_al = true;
        }

        public void func_75251_c() {
            this.entity.setTargetedEntity(0);
            this.entity.func_70624_b(null);
            this.entity.field_175481_bq.func_179480_f();
        }

        public void func_75246_d() {
            EntityLivingBase entity = this.entity.func_70638_az();
            this.entity.func_70661_as().func_75499_g();
            this.entity.func_70671_ap().func_75651_a((Entity)entity, 90.0f, 90.0f);
            if (!this.entity.func_70685_l((Entity)entity)) {
                this.entity.func_70624_b(null);
            } else {
                ++this.tickCounter;
                if (this.tickCounter == 0) {
                    this.entity.setTargetedEntity(this.entity.func_70638_az().func_145782_y());
                    this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)21);
                } else if (this.tickCounter >= this.entity.func_175464_ck()) {
                    float f = 1.0f;
                    if (this.entity.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                        f += 2.0f;
                    }
                    entity.func_70097_a(DamageSource.func_76354_b((Entity)this.entity, (Entity)this.entity), f);
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.entity), (float)this.entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    entity.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 80, 0));
                    this.entity.func_70624_b(null);
                }
                super.func_75246_d();
            }
        }
    }
}

