/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.utils.world.capability;

import com.google.common.base.Objects;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import stevekung.mods.moreplanets.utils.tileentity.TileEntityChestMP;

public class DoubleChestItemHandlerMP
extends WeakReference<TileEntityChestMP>
implements IItemHandlerModifiable {
    public static final DoubleChestItemHandlerMP NO_ADJACENT_CHESTS_INSTANCE = new DoubleChestItemHandlerMP(null, null, false);
    private final boolean mainChestIsUpper;
    private final TileEntityChestMP mainChest;
    private final int hashCode;

    public DoubleChestItemHandlerMP(@Nullable TileEntityChestMP mainChest, @Nullable TileEntityChestMP other, boolean mainChestIsUpper) {
        super(other);
        this.mainChest = mainChest;
        this.mainChestIsUpper = mainChestIsUpper;
        this.hashCode = Objects.hashCode((Object[])new Object[]{mainChestIsUpper ? mainChest : other}) * 31 + Objects.hashCode((Object[])new Object[]{!mainChestIsUpper ? mainChest : other});
    }

    public int getSlots() {
        return 54;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        TileEntityChestMP chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.func_70301_a(targetSlot) : ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack itemStack) {
        IItemHandler singleHandler;
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        TileEntityChestMP chest = this.getChest(accessingUpperChest);
        if (chest != null && (singleHandler = chest.getSingleChestHandler()) instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)singleHandler).setStackInSlot(targetSlot, itemStack);
        }
        if ((chest = this.getChest(!accessingUpperChest)) != null) {
            chest.func_70296_d();
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack itemStack, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        TileEntityChestMP chest = this.getChest(accessingUpperChest);
        if (chest == null) {
            return itemStack;
        }
        int starting = itemStack.func_190916_E();
        ItemStack ret = chest.getSingleChestHandler().insertItem(targetSlot, itemStack, simulate);
        if (ret.func_190916_E() != starting && !simulate && (chest = this.getChest(!accessingUpperChest)) != null) {
            chest.func_70296_d();
        }
        return ret;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        TileEntityChestMP chest = this.getChest(accessingUpperChest);
        if (chest == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = chest.getSingleChestHandler().extractItem(targetSlot, amount, simulate);
        if (!ret.func_190926_b() && !simulate && (chest = this.getChest(!accessingUpperChest)) != null) {
            chest.func_70296_d();
        }
        return ret;
    }

    public int getSlotLimit(int slot) {
        boolean accessingUpperChest = slot < 27;
        return this.getChest(accessingUpperChest).func_70297_j_();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleChestItemHandlerMP that = (DoubleChestItemHandlerMP)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        TileEntityChestMP otherChest = this.getOtherChest();
        if (this.mainChestIsUpper == that.mainChestIsUpper) {
            return Objects.equal((Object)((Object)this.mainChest), (Object)((Object)that.mainChest)) && Objects.equal((Object)((Object)otherChest), (Object)((Object)that.getOtherChest()));
        }
        return Objects.equal((Object)((Object)this.mainChest), (Object)((Object)that.getOtherChest())) && Objects.equal((Object)((Object)otherChest), (Object)((Object)that.mainChest));
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Nullable
    public static DoubleChestItemHandlerMP get(TileEntityChestMP chest) {
        World world = chest.func_145831_w();
        BlockPos pos = chest.func_174877_v();
        if (world == null || pos == null || !world.func_175667_e(pos)) {
            return null;
        }
        Block blockType = chest.func_145838_q();
        EnumFacing[] horizontals = EnumFacing.field_176754_o;
        for (int i = horizontals.length - 1; i >= 0; --i) {
            TileEntity otherTE;
            EnumFacing enumfacing = horizontals[i];
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            Block block = world.func_180495_p(blockpos).func_177230_c();
            if (block != blockType || !((otherTE = world.func_175625_s(blockpos)) instanceof TileEntityChestMP)) continue;
            TileEntityChestMP otherChest = (TileEntityChestMP)otherTE;
            return new DoubleChestItemHandlerMP(chest, otherChest, enumfacing != EnumFacing.WEST && enumfacing != EnumFacing.NORTH);
        }
        return NO_ADJACENT_CHESTS_INSTANCE;
    }

    public boolean needsRefresh() {
        if (this == NO_ADJACENT_CHESTS_INSTANCE) {
            return false;
        }
        TileEntityChestMP TileEntityChestMP2 = (TileEntityChestMP)((Object)this.get());
        return TileEntityChestMP2 == null || TileEntityChestMP2.func_145837_r();
    }

    @Nullable
    private TileEntityChestMP getChest(boolean accessingUpper) {
        if (accessingUpper == this.mainChestIsUpper) {
            return this.mainChest;
        }
        return this.getOtherChest();
    }

    @Nullable
    private TileEntityChestMP getOtherChest() {
        TileEntityChestMP TileEntityChestMP2 = (TileEntityChestMP)((Object)this.get());
        return TileEntityChestMP2 != null && !TileEntityChestMP2.func_145837_r() ? TileEntityChestMP2 : null;
    }
}

