/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.api.entities;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Strings;
import java.util.UUID;
import javax.annotation.Nullable;

public class FactionHome {
    private final Vector3i BlockPosition;
    private final UUID WorldUUID;

    public FactionHome(@Nullable UUID worldUUID, @Nullable Vector3i blockPosition) {
        this.BlockPosition = blockPosition;
        this.WorldUUID = worldUUID;
    }

    public static FactionHome from(String worldUUIDAndBlockPositionString) {
        if (Strings.isNullOrEmpty((String)worldUUIDAndBlockPositionString)) {
            return null;
        }
        try {
            String splitter = "\\|";
            String worldUUIDString = worldUUIDAndBlockPositionString.split(splitter)[0];
            String vectorsString = worldUUIDAndBlockPositionString.split(splitter)[1];
            String[] vectors = vectorsString.replace("(", "").replace(")", "").replace(" ", "").split(",");
            int x = Integer.parseInt(vectors[0]);
            int y = Integer.parseInt(vectors[1]);
            int z = Integer.parseInt(vectors[2]);
            Vector3i blockPosition = Vector3i.from((int)x, (int)y, (int)z);
            UUID worldUUID = UUID.fromString(worldUUIDString);
            return new FactionHome(worldUUID, blockPosition);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public UUID getWorldUUID() {
        return this.WorldUUID;
    }

    public Vector3i getBlockPosition() {
        return this.BlockPosition;
    }

    public String toString() {
        return this.WorldUUID.toString() + "|" + this.BlockPosition.toString();
    }
}

