/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.api.managers;

public class ProtectionResult {
    private final boolean hasAccess;
    private final boolean isSafeZone;
    private final boolean isWarZone;
    private final boolean isEagleFeather;
    private final boolean factionPerm;
    private final boolean isAdmin;

    public static ProtectionResult ok() {
        return ProtectionResult.builder().hasAccess(true).build();
    }

    public static ProtectionResult okAdmin() {
        return ProtectionResult.builder().hasAccess(true).isAdmin(true).build();
    }

    public static ProtectionResult okEagleFeather() {
        return ProtectionResult.builder().hasAccess(true).hasEagleFeather(true).build();
    }

    public static ProtectionResult okSafeZone() {
        return ProtectionResult.builder().hasAccess(true).isSafeZone(true).build();
    }

    public static ProtectionResult okWarZone() {
        return ProtectionResult.builder().hasAccess(true).isWarZone(true).build();
    }

    public static ProtectionResult okFactionPerm() {
        return ProtectionResult.builder().hasAccess(true).factionPerm(true).build();
    }

    public static ProtectionResult forbidden() {
        return ProtectionResult.builder().build();
    }

    public static ProtectionResult forbiddenSafeZone() {
        return ProtectionResult.builder().isSafeZone(true).build();
    }

    public static ProtectionResult forbiddenWarZone() {
        return ProtectionResult.builder().isWarZone(true).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    ProtectionResult(Builder builder) {
        this.hasAccess = builder.hasAccess;
        this.isSafeZone = builder.isSafeZone;
        this.isWarZone = builder.isWarZone;
        this.isEagleFeather = builder.hasEagleFeather;
        this.factionPerm = builder.hasFactionPerm;
        this.isAdmin = builder.isAdmin;
    }

    public boolean hasAccess() {
        return this.hasAccess;
    }

    public boolean isEagleFeather() {
        return this.isEagleFeather;
    }

    public boolean isSafeZone() {
        return this.isSafeZone;
    }

    public boolean isWarZone() {
        return this.isWarZone;
    }

    public boolean hasFactionPerms() {
        return this.factionPerm;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public static class Builder {
        private boolean hasAccess = false;
        private boolean isSafeZone = false;
        private boolean isWarZone = false;
        private boolean hasEagleFeather = false;
        private boolean hasFactionPerm = false;
        private boolean isAdmin = false;

        public Builder hasAccess(boolean hasAccess) {
            this.hasAccess = hasAccess;
            return this;
        }

        public Builder isAdmin(boolean isAdmin) {
            this.isAdmin = isAdmin;
            return this;
        }

        public Builder hasEagleFeather(boolean hasEagleFeather) {
            this.hasEagleFeather = hasEagleFeather;
            return this;
        }

        public Builder isSafeZone(boolean isSafeZone) {
            this.isSafeZone = isSafeZone;
            return this;
        }

        public Builder isWarZone(boolean isWarZone) {
            this.isWarZone = isWarZone;
            return this;
        }

        public Builder factionPerm(boolean hasFactionPerm) {
            this.hasFactionPerm = hasFactionPerm;
            return this;
        }

        public ProtectionResult build() {
            return new ProtectionResult(this);
        }
    }
}

