/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.args;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

public class BackupNameArgument
extends CommandElement {
    private EagleFactions plugin;

    public BackupNameArgument(EagleFactions plugin, @Nullable Text key) {
        super(key);
        this.plugin = plugin;
    }

    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        if (!args.hasNext()) {
            throw args.createError((Text)Text.of((String)"Argument is not a valid backup name!"));
        }
        String backupName = args.next();
        if (!this.plugin.getStorageManager().listBackups().contains(backupName)) {
            throw args.createError((Text)Text.of((String)"Argument is not a valid backup name!"));
        }
        return backupName;
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        List<String> backups = this.plugin.getStorageManager().listBackups();
        ArrayList<String> list = new ArrayList<String>(backups);
        Collections.sort(list);
        if (args.hasNext()) {
            String charSequence = ((String)args.nextIfPresent().get()).toLowerCase();
            return list.stream().filter(x -> x.toLowerCase().contains(charSequence)).collect(Collectors.toList());
        }
        return list;
    }
}

