/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.general;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ImmutableMap;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.events.EventRunner;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholder;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class MapCommand
extends AbstractCommand {
    private final ProtectionConfig protectionConfig;
    private final FactionsConfig factionsConfig;
    private final FactionLogic factionLogic;

    public MapCommand(EagleFactions plugin) {
        super(plugin);
        this.factionLogic = plugin.getFactionLogic();
        this.protectionConfig = plugin.getConfiguration().getProtectionConfig();
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        if (source instanceof Player) {
            Player player = (Player)source;
            if (this.protectionConfig.getClaimableWorldNames().contains(player.getWorld().getName())) {
                this.generateMap(player);
            } else {
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANT_VIEW_MAP_IN_THIS_WORLD}));
            }
        } else {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        return CommandResult.success();
    }

    private void generateMap(Player player) {
        Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        boolean showPlayerFactionClaimsOnly = this.factionsConfig.shouldShowOnlyPlayerFactionsClaimsInMap();
        World world = player.getWorld();
        Text notCapturedMark = Text.of((Object[])new Object[]{TextColors.GRAY, "/"});
        Text factionMark = Text.of((Object[])new Object[]{TextColors.GREEN, "+"});
        Text truceMark = Text.of((Object[])new Object[]{TextColors.GRAY, "+"});
        Text allianceMark = Text.of((Object[])new Object[]{TextColors.AQUA, "+"});
        Text enemyMark = Text.of((Object[])new Object[]{TextColors.RED, "#"});
        Text normalFactionMark = Text.of((Object[])new Object[]{TextColors.WHITE, "+"});
        Text playerLocationMark = Text.of((Object[])new Object[]{TextColors.GOLD, "+"});
        Vector3i playerPosition = player.getLocation().getChunkPosition();
        ArrayList<Text> map = new ArrayList<Text>();
        ArrayList<String> normalFactions = new ArrayList<String>();
        ArrayList<String> truceFactions = new ArrayList<String>();
        ArrayList<String> allianceFactions = new ArrayList<String>();
        ArrayList<String> enemyFactions = new ArrayList<String>();
        int mapWidth = 18;
        int mapHeight = 8;
        int halfMapWidth = mapWidth / 2;
        int halfMapHeight = mapHeight / 2;
        for (int row = -halfMapHeight; row <= halfMapHeight; ++row) {
            Text.Builder textBuilder = Text.builder();
            for (int column = -halfMapWidth; column <= halfMapWidth; ++column) {
                if (row == 0 && column == 0) {
                    textBuilder.append(new Text[]{playerLocationMark});
                    continue;
                }
                Vector3i chunk = playerPosition.add(column, 0, row);
                UUID uuid = world.getUniqueId();
                Optional<Faction> optionalFaction = this.factionLogic.getFactionByChunk(uuid, chunk);
                if (optionalFaction != null && optionalFaction.isPresent()) {
                    Faction chunkFaction = optionalFaction.get();
                    if (optionalPlayerFaction.isPresent()) {
                        Faction playerFaction = optionalPlayerFaction.get();
                        if (chunkFaction.getName().equals(playerFaction.getName())) {
                            textBuilder.append(new Text[]{factionMark.toBuilder().onClick((ClickAction)TextActions.executeCallback(this.claimByMap(player, chunk))).build()});
                            continue;
                        }
                        if (!showPlayerFactionClaimsOnly && playerFaction.getAlliances().contains(chunkFaction.getName())) {
                            textBuilder.append(new Text[]{allianceMark});
                            if (allianceFactions.contains(chunkFaction.getName())) continue;
                            allianceFactions.add(chunkFaction.getName());
                            continue;
                        }
                        if (!showPlayerFactionClaimsOnly && playerFaction.getTruces().contains(chunkFaction.getName())) {
                            textBuilder.append(new Text[]{truceMark});
                            if (truceFactions.contains(chunkFaction.getName())) continue;
                            truceFactions.add(chunkFaction.getName());
                            continue;
                        }
                        if (!showPlayerFactionClaimsOnly && playerFaction.getEnemies().contains(chunkFaction.getName())) {
                            textBuilder.append(new Text[]{enemyMark});
                            if (enemyFactions.contains(chunkFaction.getName())) continue;
                            enemyFactions.add(chunkFaction.getName());
                            continue;
                        }
                        if (chunkFaction.isSafeZone()) {
                            textBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "+"})});
                        } else if (chunkFaction.isWarZone()) {
                            textBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_RED, "#"})});
                        } else if (!showPlayerFactionClaimsOnly) {
                            textBuilder.append(new Text[]{normalFactionMark});
                        } else {
                            textBuilder.append(new Text[]{notCapturedMark});
                        }
                        if (showPlayerFactionClaimsOnly || normalFactions.contains(chunkFaction.getName())) continue;
                        normalFactions.add(chunkFaction.getName());
                        continue;
                    }
                    if (chunkFaction.isSafeZone()) {
                        textBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "+"})});
                    } else if (chunkFaction.isWarZone()) {
                        textBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_RED, "#"})});
                    } else if (!showPlayerFactionClaimsOnly) {
                        textBuilder.append(new Text[]{normalFactionMark});
                    } else {
                        textBuilder.append(new Text[]{notCapturedMark});
                    }
                    if (showPlayerFactionClaimsOnly || normalFactions.contains(chunkFaction.getName())) continue;
                    normalFactions.add(chunkFaction.getName());
                    continue;
                }
                if (!this.factionsConfig.shouldDelayClaim() && (super.getPlugin().getPlayerManager().hasAdminMode((User)player) || optionalPlayerFaction.isPresent() && (optionalPlayerFaction.get().getLeader().equals(player.getUniqueId()) || optionalPlayerFaction.get().getOfficers().contains(player.getUniqueId())))) {
                    textBuilder.append(new Text[]{notCapturedMark.toBuilder().onClick((ClickAction)TextActions.executeCallback(this.claimByMap(player, chunk))).build()});
                    continue;
                }
                textBuilder.append(new Text[]{notCapturedMark});
            }
            map.add(textBuilder.build());
        }
        String playerPositionClaim = "none";
        Optional<Faction> optionalPlayerPositionFaction = this.getPlugin().getFactionLogic().getFactionByChunk(world.getUniqueId(), playerPosition);
        if (optionalPlayerPositionFaction.isPresent()) {
            playerPositionClaim = optionalPlayerPositionFaction.get().getName();
        }
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, Messages.FACTIONS_MAP_HEADER}));
        for (Text text : map) {
            player.sendMessage(Text.of((Object[])new Object[]{text}));
        }
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, Messages.FACTIONS_MAP_FOOTER}));
        if (optionalPlayerFaction.isPresent()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, Messages.YOUR_FACTION + ": ", TextColors.GREEN, optionalPlayerFaction.get().getName()}));
        }
        if (!normalFactions.isEmpty()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.WHITE, Messages.FACTIONS + ": ", TextColors.RESET, String.join((CharSequence)",", normalFactions)}));
        }
        if (!truceFactions.isEmpty()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.AQUA, Messages.TRUCES + ": " + String.join((CharSequence)",", truceFactions)}));
        }
        if (!allianceFactions.isEmpty()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.AQUA, Messages.ALLIANCES + ": " + String.join((CharSequence)",", allianceFactions)}));
        }
        if (!enemyFactions.isEmpty()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, Messages.ENEMIES + ": " + String.join((CharSequence)",", enemyFactions)}));
        }
        player.sendMessage(Text.of((Object[])new Object[]{MessageLoader.parseMessage(Messages.CURRENTLY_STANDING_AT_CLAIM_WHICH_IS_CLAIMED_BY, TextColors.RESET, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.CLAIM, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, playerPosition.toString()}), (Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, playerPositionClaim})))}));
    }

    private Consumer<CommandSource> claimByMap(Player player, Vector3i chunk) {
        return consumer -> {
            Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
            World world = player.getWorld();
            Claim claim = new Claim(player.getWorld().getUniqueId(), chunk);
            boolean hasFactionsAdminMode = super.getPlugin().getPlayerManager().hasAdminMode((User)player);
            if (!optionalPlayerFaction.isPresent()) {
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
                return;
            }
            Faction playerFaction = optionalPlayerFaction.get();
            boolean hasClaimPermission = super.getPlugin().getPermsManager().canClaim(player.getUniqueId(), playerFaction);
            boolean isFactionAttacked = EagleFactionsPlugin.ATTACKED_FACTIONS.containsKey(playerFaction.getName());
            if (!hasFactionsAdminMode && !hasClaimPermission) {
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.PLAYERS_WITH_YOUR_RANK_CANT_CLAIM_LANDS}));
                return;
            }
            if (super.getPlugin().getFactionLogic().isClaimed(world.getUniqueId(), chunk)) {
                Location homeLocation;
                if (EventRunner.runFactionUnclaimEventPre(player, playerFaction, world, chunk)) {
                    return;
                }
                if (playerFaction.getHome() != null && world.getUniqueId().equals(playerFaction.getHome().getWorldUUID()) && (homeLocation = world.getLocation(playerFaction.getHome().getBlockPosition())).getChunkPosition().toString().equals(player.getLocation().getChunkPosition().toString())) {
                    super.getPlugin().getFactionLogic().setHome(playerFaction, null);
                }
                super.getPlugin().getFactionLogic().removeClaim(playerFaction, new Claim(world.getUniqueId(), chunk));
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, Messages.LAND_HAS_BEEN_SUCCESSFULLY_UNCLAIMED}));
                EventRunner.runFactionUnclaimEventPost(player, playerFaction, world, chunk);
            } else {
                if (isFactionAttacked) {
                    player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOUR_FACTION_IS_UNDER_ATTACK + " ", MessageLoader.parseMessage(Messages.YOU_NEED_TO_WAIT_NUMBER_SECONDS_TO_BE_ABLE_TO_CLAIM_AGAIN, TextColors.RED, Collections.singletonMap(Placeholders.NUMBER, Text.of((Object[])new Object[]{TextColors.GOLD, EagleFactionsPlugin.ATTACKED_FACTIONS.get(playerFaction.getName())})))}));
                    return;
                }
                if (super.getPlugin().getPowerManager().getFactionMaxClaims(playerFaction) <= playerFaction.getClaims().size()) {
                    player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOUR_FACTION_DOES_NOT_HAVE_POWER_TO_CLAIM_MORE_LANDS}));
                    return;
                }
                if (playerFaction.isSafeZone() || playerFaction.isWarZone()) {
                    if (EventRunner.runFactionClaimEventPre(player, playerFaction, world, chunk)) {
                        return;
                    }
                    super.getPlugin().getFactionLogic().addClaim(playerFaction, claim);
                    player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, Messages.LAND + " ", TextColors.GOLD, chunk.toString(), TextColors.WHITE, " " + Messages.HAS_BEEN_SUCCESSFULLY + " ", TextColors.GOLD, Messages.CLAIMED, TextColors.WHITE, "!"}));
                } else if (this.factionsConfig.requireConnectedClaims()) {
                    if (super.getPlugin().getFactionLogic().isClaimConnected(playerFaction, claim)) {
                        if (EventRunner.runFactionClaimEventPre(player, playerFaction, world, chunk)) {
                            return;
                        }
                        super.getPlugin().getFactionLogic().startClaiming(player, playerFaction, world.getUniqueId(), chunk);
                    } else {
                        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.CLAIMS_NEED_TO_BE_CONNECTED}));
                    }
                } else {
                    if (EventRunner.runFactionClaimEventPre(player, playerFaction, world, chunk)) {
                        return;
                    }
                    super.getPlugin().getFactionLogic().startClaiming(player, playerFaction, world.getUniqueId(), chunk);
                }
            }
            this.generateMap(player);
        };
    }
}

