/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.general;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.data.manipulator.mutable.entity.JoinData;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class PlayerCommand
extends AbstractCommand {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");

    public PlayerCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Optional optionalPlayer = context.getOne("player");
        if (optionalPlayer.isPresent()) {
            FactionPlayer player = (FactionPlayer)optionalPlayer.get();
            this.showPlayerInfo(source, player);
        } else if (source instanceof Player) {
            Player player = (Player)source;
            Optional<FactionPlayer> optionalFactionPlayer = super.getPlugin().getPlayerManager().getFactionPlayer(player.getUniqueId());
            if (!optionalFactionPlayer.isPresent()) {
                return CommandResult.success();
            }
            FactionPlayer factionPlayer = optionalFactionPlayer.get();
            this.showPlayerInfo(source, factionPlayer);
        }
        return CommandResult.success();
    }

    private void showPlayerInfo(CommandSource source, FactionPlayer factionPlayer) {
        Optional joinData;
        ArrayList<Text> playerInfo = new ArrayList<Text>();
        String playerFactionName = "";
        if (factionPlayer.getFactionName().isPresent()) {
            playerFactionName = factionPlayer.getFactionName().get();
        }
        LocalDateTime lastPlayed = LocalDateTime.now();
        Optional<User> optionalUser = factionPlayer.getUser();
        if (optionalUser.isPresent() && (joinData = optionalUser.get().get(JoinData.class)).isPresent()) {
            JoinData data = (JoinData)joinData.get();
            Instant instant = (Instant)data.lastPlayed().get();
            lastPlayed = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        String formattedDate = DATE_TIME_FORMATTER.format(lastPlayed);
        boolean isOnline = optionalUser.isPresent() && optionalUser.get().isOnline();
        Text online = isOnline ? Text.of((Object[])new Object[]{TextColors.GREEN, "ONLINE"}) : Text.of((Object[])new Object[]{TextColors.RED, "OFFLINE"});
        Text info = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, Messages.NAME + ": ", TextColors.GOLD, factionPlayer.getName() + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, Messages.PLAYER_STATUS + ": "})}).append(new Text[]{online}).append(new Text[]{Text.of((String)"\n")}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, Messages.FACTION + ": ", TextColors.GOLD, playerFactionName + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, Messages.POWER + ": ", TextColors.GOLD, factionPlayer.getPower() + "/" + factionPlayer.getMaxPower() + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, Messages.LAST_PLAYED + ": ", TextColors.GOLD, formattedDate})}).build();
        playerInfo.add(info);
        PaginationList.Builder paginationBuilder = PaginationList.builder().title(Text.of((Object[])new Object[]{TextColors.GREEN, Messages.PLAYER_INFO})).padding((Text)Text.of((String)"=")).contents(playerInfo);
        paginationBuilder.sendTo((MessageReceiver)source);
    }
}

