/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjc.core;

import com.google.common.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Optional;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.api.item.inventory.ItemStack;

public class ItemSerializer {
    public static Optional<String> serialize(ItemStack item) {
        try {
            StringWriter sink = new StringWriter();
            HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setSink(() -> new BufferedWriter(sink))).build();
            loader.save(((CommentedConfigurationNode)loader.createEmptyNode()).setValue(TypeToken.of(ItemStack.class), (Object)item));
            return Optional.of(sink.toString());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<ItemStack> deserialize(String item) {
        try {
            HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setSource(() -> new BufferedReader(new StringReader(item)))).build();
            return Optional.of(((CommentedConfigurationNode)loader.load()).getValue(TypeToken.of(ItemStack.class)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }
}

