/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.facet;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Knob {
    private static final String NAMESPACE = "net.kyo".concat("ri.adventure");
    private static final boolean DEBUG = Knob.isEnabled("debug", false);
    private static final Set<Object> UNSUPPORTED = new CopyOnWriteArraySet<Object>();
    public static volatile Consumer<String> OUT = System.out::println;
    public static volatile BiConsumer<String, Throwable> ERR = (message, err) -> {
        System.err.println((String)message);
        if (err != null) {
            err.printStackTrace(System.err);
        }
    };

    private Knob() {
    }

    public static boolean isEnabled(@NonNull String key, boolean defaultValue) {
        return System.getProperty(NAMESPACE + "." + key, Boolean.toString(defaultValue)).equalsIgnoreCase("true");
    }

    public static void logError(@Nullable Throwable error, @NonNull String format, Object ... arguments) {
        if (DEBUG) {
            ERR.accept(String.format(format, arguments), error);
        }
    }

    public static void logMessage(@NonNull String format, Object ... arguments) {
        if (DEBUG) {
            OUT.accept(String.format(format, arguments));
        }
    }

    public static void logUnsupported(@NonNull Object facet, @NonNull Object value) {
        if (DEBUG && UNSUPPORTED.add(value)) {
            OUT.accept(String.format("Unsupported value '%s' for facet: %s", value, facet));
        }
    }
}

