/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.config;

import com.erigitic.config.TEAccount;
import com.erigitic.config.TECurrency;
import com.erigitic.config.TEVirtualAccount;
import com.erigitic.main.TotalEconomy;
import com.erigitic.sql.SqlManager;
import com.erigitic.sql.SqlQuery;
import com.erigitic.util.MessageManager;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.economy.account.Account;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class AccountManager
implements EconomyService {
    private TotalEconomy totalEconomy;
    private MessageManager messageManager;
    private Logger logger;
    private ConfigurationLoader<CommentedConfigurationNode> loader;
    private ConfigurationNode accountConfig;
    private SqlManager sqlManager;
    private boolean databaseActive;
    private boolean confSaveRequested = false;
    public static final int CONTENT_VERSION = 1;

    public AccountManager(TotalEconomy totalEconomy, MessageManager messageManager, Logger logger) {
        this.totalEconomy = totalEconomy;
        this.messageManager = messageManager;
        this.logger = logger;
        this.databaseActive = totalEconomy.isDatabaseEnabled();
        if (this.databaseActive) {
            this.sqlManager = totalEconomy.getSqlManager();
            this.setupDatabase();
        } else {
            this.setupConfig();
            if (totalEconomy.getSaveInterval() > 0) {
                this.setupAutosave();
            }
        }
    }

    private void setupConfig() {
        File accountsFile = new File(this.totalEconomy.getConfigDir(), "accounts.conf");
        this.loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(accountsFile)).build();
        try {
            this.accountConfig = this.loader.load();
            if (!accountsFile.exists()) {
                this.loader.save(this.accountConfig);
            } else if (this.accountConfig.getNode(new Object[]{"version"}).getInt(0) != 1) {
                this.accountConfig.getChildrenMap().entrySet().parallelStream().forEach(nodeEntry -> {
                    ConfigurationNode accountNode = (ConfigurationNode)nodeEntry.getValue();
                    accountNode.getNode(new Object[]{"jobstats"}).getChildrenMap().entrySet().parallelStream().forEach(jobNodeEntry -> {
                        ConfigurationNode jobNode = (ConfigurationNode)jobNodeEntry.getValue();
                        ConfigurationNode expNode = jobNode.getNode(new Object[]{"exp"});
                        int exp = expNode.getInt(0);
                        int level = jobNode.getNode(new Object[]{"level"}).getInt(0);
                        expNode.setValue((Object)((int)((double)exp + ((Math.pow(level, 2.0) + (double)level) / 2.0 * 100.0 - (double)(level * 100)))));
                        try {
                            this.loader.save(this.accountConfig);
                        }
                        catch (IOException e) {
                            this.logger.warn("Error migrating account experience values!");
                        }
                    });
                });
                this.accountConfig.getNode(new Object[]{"version"}).setValue((Object)1);
            }
        }
        catch (IOException e) {
            this.logger.warn("Error creating accounts configuration file!");
        }
    }

    public void setupDatabase() {
        String currencyCols = "";
        for (Currency currency : this.getCurrencies()) {
            TECurrency teCurrency = (TECurrency)currency;
            currencyCols = currencyCols + teCurrency.getName().toLowerCase() + "_balance decimal(19,2) NOT NULL DEFAULT '" + teCurrency.getStartingBalance() + "',";
        }
        this.sqlManager.createTable("accounts", "uid varchar(60) NOT NULL," + currencyCols + "job varchar(50) NOT NULL DEFAULT 'Unemployed',job_notifications boolean NOT NULL DEFAULT TRUE,PRIMARY KEY (uid)");
        this.sqlManager.createTable("virtual_accounts", "uid varchar(60) NOT NULL," + currencyCols + "PRIMARY KEY (uid)");
        this.sqlManager.createTable("levels", "uid varchar(60),miner int(10) unsigned NOT NULL DEFAULT '1',lumberjack int(10) unsigned NOT NULL DEFAULT '1',warrior int(10) unsigned NOT NULL DEFAULT '1',fisherman int(10) unsigned NOT NULL DEFAULT '1',FOREIGN KEY (uid) REFERENCES accounts(uid) ON DELETE CASCADE");
        this.sqlManager.createTable("experience", "uid varchar(60),miner int(10) unsigned NOT NULL DEFAULT '0',lumberjack int(10) unsigned NOT NULL DEFAULT '0',warrior int(10) unsigned NOT NULL DEFAULT '0',fisherman int(10) unsigned NOT NULL DEFAULT '0',FOREIGN KEY (uid) REFERENCES accounts(uid) ON DELETE CASCADE");
    }

    private void setupAutosave() {
        Sponge.getScheduler().createTaskBuilder().interval((long)this.totalEconomy.getSaveInterval(), TimeUnit.SECONDS).execute(() -> {
            if (this.confSaveRequested) {
                this.saveConfiguration();
                this.confSaveRequested = false;
            }
        }).submit((Object)this.totalEconomy);
    }

    public void reloadConfig() {
        try {
            this.accountConfig = this.loader.load();
            this.logger.info("Reloading account configuration file.");
        }
        catch (IOException e) {
            this.logger.warn("An error occurred while reloading the account configuration file!");
        }
    }

    public Optional<UniqueAccount> getOrCreateAccount(UUID uuid) {
        TEAccount playerAccount = new TEAccount(this.totalEconomy, this, uuid);
        boolean hasAccount = this.hasAccount(uuid);
        try {
            if (!hasAccount) {
                if (this.databaseActive) {
                    this.createAccountInDatabase(playerAccount);
                } else {
                    this.createAccountInConfig(playerAccount);
                }
            } else if (hasAccount && !this.databaseActive) {
                this.addNewCurrenciesToAccount(playerAccount);
            }
        }
        catch (IOException e) {
            this.logger.warn("An error occurred while creating a new account!");
        }
        return Optional.of(playerAccount);
    }

    public Optional<Account> getOrCreateAccount(String identifier) {
        TEVirtualAccount virtualAccount = new TEVirtualAccount(this.totalEconomy, this, identifier);
        boolean hasAccount = this.hasAccount(identifier);
        try {
            if (!hasAccount) {
                if (this.databaseActive) {
                    this.createAccountInDatabase(virtualAccount);
                } else {
                    this.createAccountInConfig(virtualAccount);
                }
            } else if (hasAccount && !this.databaseActive) {
                this.addNewCurrenciesToAccount(virtualAccount);
            }
        }
        catch (IOException e) {
            this.logger.warn("An error occurred while creating a new virtual account!");
        }
        return Optional.of(virtualAccount);
    }

    public boolean hasAccount(UUID uuid) {
        if (this.databaseActive) {
            SqlQuery query = SqlQuery.builder(this.sqlManager.dataSource).select("uid").from("accounts").where("uid").equals(uuid.toString()).build();
            return query.recordExists();
        }
        return this.accountConfig.getNode(new Object[]{uuid.toString()}).getValue() != null;
    }

    public boolean hasAccount(String identifier) {
        if (this.databaseActive) {
            SqlQuery query = SqlQuery.builder(this.sqlManager.dataSource).select("uid").from("virtual_accounts").where("uid").equals(identifier).build();
            return query.recordExists();
        }
        return this.accountConfig.getNode(new Object[]{identifier}).getValue() != null;
    }

    public Currency getDefaultCurrency() {
        return this.totalEconomy.getDefaultCurrency();
    }

    public Set<Currency> getCurrencies() {
        return this.totalEconomy.getCurrencies();
    }

    public void registerContextCalculator(ContextCalculator calculator) {
    }

    private void createAccountInDatabase(TEAccount playerAccount) {
        UUID uuid = playerAccount.getUniqueId();
        SqlQuery.builder(this.sqlManager.dataSource).insert("accounts").columns("uid", "job", "job_notifications").values(uuid.toString(), "unemployed", String.valueOf(this.totalEconomy.isJobNotificationEnabled())).build();
        SqlQuery.builder(this.sqlManager.dataSource).insert("levels").columns("uid").values(uuid.toString()).build();
        SqlQuery.builder(this.sqlManager.dataSource).insert("experience").columns("uid").values(uuid.toString()).build();
        for (Currency currency : this.totalEconomy.getCurrencies()) {
            TECurrency teCurrency = (TECurrency)currency;
            SqlQuery.builder(this.sqlManager.dataSource).update("accounts").set(teCurrency.getName().toLowerCase() + "_balance").equals(playerAccount.getDefaultBalance(teCurrency).toString()).where("uid").equals(uuid.toString()).build();
        }
    }

    private void createAccountInDatabase(TEVirtualAccount virtualAccount) {
        String identifier = virtualAccount.getIdentifier();
        for (Currency currency : this.totalEconomy.getCurrencies()) {
            TECurrency teCurrency = (TECurrency)currency;
            SqlQuery.builder(this.sqlManager.dataSource).insert("virtual_accounts").columns(teCurrency.getName().toLowerCase() + "_balance").values(virtualAccount.getDefaultBalance(teCurrency).toString()).where("uid").equals(identifier).build();
        }
    }

    private void createAccountInConfig(TEAccount playerAccount) throws IOException {
        UUID uuid = playerAccount.getUniqueId();
        for (Currency currency : this.totalEconomy.getCurrencies()) {
            TECurrency teCurrency = (TECurrency)currency;
            this.accountConfig.getNode(new Object[]{uuid.toString(), teCurrency.getName().toLowerCase() + "-balance"}).setValue((Object)playerAccount.getDefaultBalance(teCurrency));
        }
        this.accountConfig.getNode(new Object[]{uuid.toString(), "job"}).setValue((Object)"unemployed");
        this.accountConfig.getNode(new Object[]{uuid.toString(), "jobnotifications"}).setValue((Object)this.totalEconomy.isJobNotificationEnabled());
        this.loader.save(this.accountConfig);
    }

    private void createAccountInConfig(TEVirtualAccount virtualAccount) throws IOException {
        String identifier = virtualAccount.getIdentifier();
        for (Currency currency : this.totalEconomy.getCurrencies()) {
            TECurrency teCurrency = (TECurrency)currency;
            this.accountConfig.getNode(new Object[]{identifier, teCurrency.getName().toLowerCase() + "-balance"}).setValue((Object)virtualAccount.getDefaultBalance(teCurrency));
        }
        this.loader.save(this.accountConfig);
    }

    private void addNewCurrenciesToAccount(TEAccount playerAccount) throws IOException {
        UUID uuid = playerAccount.getUniqueId();
        for (Currency currency : this.totalEconomy.getCurrencies()) {
            TECurrency teCurrency = (TECurrency)currency;
            if (playerAccount.hasBalance(teCurrency)) continue;
            this.accountConfig.getNode(new Object[]{uuid.toString(), teCurrency.getName().toLowerCase() + "-balance"}).setValue((Object)playerAccount.getDefaultBalance(teCurrency));
        }
        this.loader.save(this.accountConfig);
    }

    private void addNewCurrenciesToAccount(TEVirtualAccount virtualAccount) throws IOException {
        String identifier = virtualAccount.getIdentifier();
        for (Currency currency : this.totalEconomy.getCurrencies()) {
            TECurrency teCurrency = (TECurrency)currency;
            if (virtualAccount.hasBalance(teCurrency)) continue;
            this.accountConfig.getNode(new Object[]{identifier, teCurrency.getName().toLowerCase() + "-balance"}).setValue((Object)virtualAccount.getDefaultBalance(teCurrency));
        }
        this.loader.save(this.accountConfig);
    }

    public boolean getJobNotificationState(Player player) {
        UUID playerUniqueId = player.getUniqueId();
        if (this.databaseActive) {
            SqlQuery sqlQuery = SqlQuery.builder(this.sqlManager.dataSource).select("job_notifications").from("accounts").where("uid").equals(playerUniqueId.toString()).build();
            return sqlQuery.getBoolean(true);
        }
        return this.accountConfig.getNode(new Object[]{player.getUniqueId().toString(), "jobnotifications"}).getBoolean(true);
    }

    public void toggleNotifications(Player player) {
        boolean jobNotifications = !this.getJobNotificationState(player);
        UUID playerUniqueId = player.getUniqueId();
        if (this.databaseActive) {
            SqlQuery sqlQuery = SqlQuery.builder(this.sqlManager.dataSource).update("accounts").set("job_notifications").equals(jobNotifications ? "1" : "0").where("uid").equals(playerUniqueId.toString()).build();
            if (sqlQuery.getRowsAffected() <= 0) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Error toggling notifications! Try again. If this keeps showing up, notify the server owner or plugin developer."}));
                this.logger.warn("An error occurred while updating the notification state in the database!");
            }
        } else {
            this.accountConfig.getNode(new Object[]{player.getUniqueId().toString(), "jobnotifications"}).setValue((Object)jobNotifications);
            try {
                this.loader.save(this.accountConfig);
            }
            catch (IOException e) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Error toggling notifications! Try again. If this keeps showing up, notify the server owner or plugin developer."}));
                this.logger.warn("An error occurred while updating the notification state!");
            }
        }
        if (jobNotifications) {
            player.sendMessage(this.messageManager.getMessage("notifications.on"));
        } else {
            player.sendMessage(this.messageManager.getMessage("notifications.off"));
        }
    }

    public Optional<String> getUserOption(String option, User user) {
        if (this.databaseActive) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.accountConfig.getNode(new Object[]{user.getUniqueId().toString(), "options", option}).getString(null));
    }

    public void setUserOption(String option, User user, String value) {
        if (this.databaseActive) {
            return;
        }
        this.accountConfig.getNode(new Object[]{user.getUniqueId().toString(), "options", option}).setValue((Object)value);
    }

    public void requestConfigurationSave() {
        if (this.totalEconomy.getSaveInterval() > 0) {
            this.confSaveRequested = true;
        } else {
            this.saveConfiguration();
        }
    }

    public void saveConfiguration() {
        try {
            this.loader.save(this.accountConfig);
        }
        catch (IOException e) {
            this.logger.error("An error occurred while saving the account configuration file!");
        }
    }

    public ConfigurationNode getAccountConfig() {
        return this.accountConfig;
    }

    public ConfigurationLoader<CommentedConfigurationNode> getConfigManager() {
        return this.loader;
    }
}

