/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.jobs;

import com.erigitic.config.AccountManager;
import com.erigitic.config.TEAccount;
import com.erigitic.config.TECurrency;
import com.erigitic.jobs.TEAction;
import com.erigitic.jobs.TEActionReward;
import com.erigitic.jobs.TEJob;
import com.erigitic.jobs.TEJobSet;
import com.erigitic.main.TotalEconomy;
import com.erigitic.sql.SqlManager;
import com.erigitic.sql.SqlQuery;
import com.erigitic.util.MessageManager;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.Sign;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.block.trait.BlockTrait;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.manipulator.mutable.item.FishData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.SignData;
import org.spongepowered.api.data.type.Fish;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.action.FishingEvent;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.block.tileentity.ChangeSignEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.world.Location;

public class JobManager {
    private TotalEconomy totalEconomy;
    private AccountManager accountManager;
    private MessageManager messageManager;
    private Logger logger;
    private SqlManager sqlManager;
    private File jobSetsFile;
    private ConfigurationLoader<CommentedConfigurationNode> jobSetsLoader;
    private ConfigurationNode jobSetsConfig;
    private Map<String, TEJobSet> jobSets;
    private File jobsFile;
    private ConfigurationLoader<CommentedConfigurationNode> jobsLoader;
    private ConfigurationNode jobsConfig;
    private Map<String, TEJob> jobsMap;
    private boolean databaseEnabled;

    public JobManager(TotalEconomy totalEconomy, AccountManager accountManager, MessageManager messageManager, Logger logger) {
        this.totalEconomy = totalEconomy;
        this.accountManager = accountManager;
        this.messageManager = messageManager;
        this.logger = logger;
        this.databaseEnabled = totalEconomy.isDatabaseEnabled();
        if (this.databaseEnabled) {
            this.sqlManager = totalEconomy.getSqlManager();
        }
        this.setupConfig();
        if (totalEconomy.isJobSalaryEnabled()) {
            this.startSalaryTask();
        }
    }

    private void startSalaryTask() {
        Scheduler scheduler = this.totalEconomy.getGame().getScheduler();
        Task.Builder payTask = scheduler.createTaskBuilder();
        payTask.execute(() -> {
            for (Player player : this.totalEconomy.getServer().getOnlinePlayers()) {
                Optional<TEJob> optJob = this.getJob(this.getPlayerJob((User)player), true);
                if (!optJob.isPresent()) {
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "[TE] Cannot pay your salary! Contact your administrator!"}));
                    return;
                }
                if (!optJob.get().salaryEnabled()) continue;
                BigDecimal salary = optJob.get().getSalary();
                TEAccount playerAccount = (TEAccount)this.accountManager.getOrCreateAccount(player.getUniqueId()).get();
                EventContext eventContext = EventContext.builder().add(EventContextKeys.PLAYER, (Object)player).build();
                Cause cause = Cause.builder().append((Object)this.totalEconomy.getPluginContainer()).build(eventContext);
                TransactionResult result = playerAccount.deposit(this.totalEconomy.getDefaultCurrency(), salary, cause);
                if (result.getResult() == ResultType.SUCCESS) {
                    HashMap<String, String> messageValues = new HashMap<String, String>();
                    messageValues.put("amount", this.totalEconomy.getDefaultCurrency().format(salary).toPlain());
                    player.sendMessage(this.messageManager.getMessage("jobs.salary", messageValues));
                    continue;
                }
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "[TE] Failed to pay your salary! You may want to contact your admin - TransactionResult: ", result.getResult().toString()}));
            }
        }).delay((long)this.jobsConfig.getNode(new Object[]{"salarydelay"}).getInt(), TimeUnit.SECONDS).interval((long)this.jobsConfig.getNode(new Object[]{"salarydelay"}).getInt(), TimeUnit.SECONDS).name("Pay Day").submit((Object)this.totalEconomy);
    }

    public void setupConfig() {
        this.jobSetsFile = new File(this.totalEconomy.getConfigDir(), "jobsets.conf");
        this.jobSetsLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(this.jobSetsFile)).build();
        this.jobSets = new HashMap<String, TEJobSet>();
        this.reloadJobSetConfig();
        this.jobsFile = new File(this.totalEconomy.getConfigDir(), "jobs.conf");
        this.jobsLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(this.jobsFile)).build();
        this.jobsMap = new HashMap<String, TEJob>();
        this.reloadJobsConfig();
    }

    public boolean reloadJobSetConfig() {
        try {
            if (!this.jobSetsFile.exists()) {
                ((Asset)this.totalEconomy.getPluginContainer().getAsset("jobsets.conf").get()).copyToFile(this.jobSetsFile.toPath());
            }
            this.jobSetsConfig = this.jobSetsLoader.load();
            ConfigurationNode sets = this.jobSetsConfig.getNode(new Object[]{"sets"});
            sets.getChildrenMap().forEach((setName, setNode) -> {
                if (setNode != null) {
                    TEJobSet jobSet = new TEJobSet((ConfigurationNode)setNode);
                    this.jobSets.put((String)setName, jobSet);
                }
            });
            return true;
        }
        catch (IOException e) {
            this.logger.warn("An error occurred while creating/loading the jobSets configuration file!");
            return false;
        }
    }

    public boolean reloadJobsConfig() {
        try {
            if (!this.jobsFile.exists()) {
                ((Asset)this.totalEconomy.getPluginContainer().getAsset("jobs.conf").get()).copyToFile(this.jobsFile.toPath());
            }
            this.jobsConfig = this.jobsLoader.load();
            ConfigurationNode jobsNode = this.jobsConfig.getNode(new Object[]{"jobs"});
            jobsNode.getChildrenMap().forEach((k, jobNode) -> {
                TEJob job;
                if (jobNode != null && (job = new TEJob((ConfigurationNode)jobNode)).isValid()) {
                    this.jobsMap.put(job.getName(), job);
                }
            });
            return true;
        }
        catch (IOException e) {
            this.logger.warn("An error occurred while creating/loading the jobs configuration file!");
            return false;
        }
    }

    public boolean reloadJobsAndSets() {
        return this.reloadJobsConfig() && this.reloadJobSetConfig();
    }

    public void addExp(Player player, int expAmount) {
        String jobName = this.getPlayerJob((User)player);
        UUID playerUniqueId = player.getUniqueId();
        boolean jobNotifications = this.accountManager.getJobNotificationState(player);
        HashMap<String, String> messageValues = new HashMap<String, String>();
        messageValues.put("job", this.titleize(jobName));
        messageValues.put("exp", String.valueOf(expAmount));
        if (this.databaseEnabled) {
            int newExp = this.getJobExp(jobName, (User)player) + expAmount;
            SqlQuery sqlQuery = SqlQuery.builder(this.sqlManager.dataSource).update("experience").set(jobName).equals(String.valueOf(newExp)).where("uid").equals(playerUniqueId.toString()).build();
            if (sqlQuery.getRowsAffected() > 0) {
                if (jobNotifications) {
                    player.sendMessage(this.messageManager.getMessage("jobs.addexp", messageValues));
                }
            } else {
                this.logger.warn("An error occurred while updating job experience in the database!");
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "[TE] Error adding experience! Consult an administrator!"}));
            }
        } else {
            ConfigurationNode accountConfig = this.accountManager.getAccountConfig();
            int curExp = accountConfig.getNode(new Object[]{playerUniqueId.toString(), "jobstats", jobName, "exp"}).getInt();
            accountConfig.getNode(new Object[]{playerUniqueId.toString(), "jobstats", jobName, "exp"}).setValue((Object)(curExp + expAmount));
            if (jobNotifications) {
                player.sendMessage(this.messageManager.getMessage("jobs.addexp", messageValues));
            }
            try {
                this.accountManager.getConfigManager().save(accountConfig);
            }
            catch (IOException e) {
                this.logger.warn("An error occurred while saving the account configuration file!");
            }
        }
    }

    public void checkForLevel(Player player) {
        int expToLevel;
        UUID playerUniqueId = player.getUniqueId();
        String jobName = this.getPlayerJob((User)player);
        int playerLevel = this.getJobLevel(jobName, (User)player);
        int playerCurExp = this.getJobExp(jobName, (User)player);
        if (playerCurExp >= (expToLevel = this.getExpToLevel((User)player))) {
            HashMap<String, String> messageValues = new HashMap<String, String>();
            messageValues.put("job", this.titleize(jobName));
            messageValues.put("level", String.valueOf(++playerLevel));
            if (this.databaseEnabled) {
                SqlQuery.builder(this.sqlManager.dataSource).update("levels").set(jobName).equals(String.valueOf(playerLevel)).where("uid").equals(playerUniqueId.toString()).build();
                SqlQuery.builder(this.sqlManager.dataSource).update("experience").set(jobName).equals(String.valueOf(playerCurExp)).where("uid").equals(playerUniqueId.toString()).build();
            } else {
                ConfigurationNode accountConfig = this.accountManager.getAccountConfig();
                accountConfig.getNode(new Object[]{playerUniqueId.toString(), "jobstats", jobName, "level"}).setValue((Object)playerLevel);
                accountConfig.getNode(new Object[]{playerUniqueId.toString(), "jobstats", jobName, "exp"}).setValue((Object)playerCurExp);
            }
            player.sendMessage(this.messageManager.getMessage("jobs.levelup", messageValues));
        }
    }

    public boolean jobExists(String jobName) {
        return this.jobsConfig.getNode(new Object[]{"jobs", jobName.toLowerCase()}).getValue() != null;
    }

    public String titleize(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1).toLowerCase();
    }

    private boolean getNotificationState(UUID uuid) {
        if (this.databaseEnabled) {
            SqlQuery sqlQuery = SqlQuery.builder(this.sqlManager.dataSource).select("job_notifications").from("accounts").where("uid").equals(uuid.toString()).build();
            return sqlQuery.getBoolean(this.totalEconomy.isJobNotificationEnabled());
        }
        return this.accountManager.getAccountConfig().getNode(new Object[]{uuid.toString(), "jobnotifications"}).getBoolean();
    }

    private void notifyPlayerOfJobReward(Player player, BigDecimal amount, Currency currency) {
        Text amountText = currency.format(amount, currency.getDefaultFractionDigits());
        HashMap<String, String> messageValues = new HashMap<String, String>();
        messageValues.put("amount", amountText.toPlain());
        player.sendMessage(this.messageManager.getMessage("jobs.notify", messageValues));
    }

    public boolean setJob(User user, String jobName) {
        UUID userUniqueId = user.getUniqueId();
        jobName = jobName.toLowerCase();
        if (this.databaseEnabled) {
            SqlQuery sqlQuery = SqlQuery.builder(this.sqlManager.dataSource).update("accounts").set("job").equals(jobName).where("uid").equals(userUniqueId.toString()).build();
            if (sqlQuery.getRowsAffected() > 0) {
                return true;
            }
            this.logger.warn("An error occurred while changing the job of " + user.getUniqueId() + "/" + user.getName() + "!");
            return false;
        }
        ConfigurationNode accountConfig = this.accountManager.getAccountConfig();
        accountConfig.getNode(new Object[]{userUniqueId.toString(), "job"}).setValue((Object)jobName);
        accountConfig.getNode(new Object[]{userUniqueId.toString(), "jobstats", jobName, "level"}).setValue((Object)accountConfig.getNode(new Object[]{userUniqueId.toString(), "jobstats", jobName, "level"}).getInt(1));
        accountConfig.getNode(new Object[]{userUniqueId.toString(), "jobstats", jobName, "exp"}).setValue((Object)accountConfig.getNode(new Object[]{userUniqueId.toString(), "jobstats", jobName, "exp"}).getInt(0));
        try {
            this.accountManager.getConfigManager().save(accountConfig);
        }
        catch (IOException e) {
            this.logger.warn("An error occurred while changing the job of " + user.getUniqueId() + "/" + user.getName() + "!");
        }
        return true;
    }

    public Optional<TEJobSet> getJobSet(String name) {
        return Optional.ofNullable(this.jobSets.getOrDefault(name, null));
    }

    public String getPlayerJob(User user) {
        UUID uuid = user.getUniqueId();
        if (this.databaseEnabled) {
            SqlQuery sqlQuery = SqlQuery.builder(this.sqlManager.dataSource).select("job").from("accounts").where("uid").equals(uuid.toString()).build();
            return sqlQuery.getString("unemployed").toLowerCase();
        }
        ConfigurationNode accountConfig = this.accountManager.getAccountConfig();
        return accountConfig.getNode(new Object[]{user.getUniqueId().toString(), "job"}).getString("unemployed").toLowerCase();
    }

    public Optional<TEJob> getJob(String jobName, boolean tryUnemployed) {
        TEJob job = this.jobsMap.getOrDefault(jobName, null);
        if (job != null || !tryUnemployed) {
            return Optional.ofNullable(job);
        }
        return this.getJob("unemployed", false);
    }

    public int getJobLevel(String jobName, User user) {
        UUID playerUniqueId = user.getUniqueId();
        if (!(jobName = jobName.toLowerCase()).equals("unemployed")) {
            if (this.databaseEnabled) {
                SqlQuery sqlQuery = SqlQuery.builder(this.sqlManager.dataSource).select(jobName).from("levels").where("uid").equals(playerUniqueId.toString()).build();
                return sqlQuery.getInt(1);
            }
            ConfigurationNode accountConfig = this.accountManager.getAccountConfig();
            return accountConfig.getNode(new Object[]{user.getUniqueId().toString(), "jobstats", jobName, "level"}).getInt(1);
        }
        return 1;
    }

    public int getJobExp(String jobName, User user) {
        UUID playerUniqueId = user.getUniqueId();
        if (!(jobName = jobName.toLowerCase()).equals("unemployed")) {
            if (this.databaseEnabled) {
                SqlQuery sqlQuery = SqlQuery.builder(this.sqlManager.dataSource).select(jobName).from("experience").where("uid").equals(playerUniqueId.toString()).build();
                return sqlQuery.getInt(0);
            }
            ConfigurationNode accountConfig = this.accountManager.getAccountConfig();
            return accountConfig.getNode(new Object[]{playerUniqueId.toString(), "jobstats", jobName, "exp"}).getInt(0);
        }
        return 0;
    }

    public int getExpToLevel(User user) {
        String jobName = this.getPlayerJob(user);
        int playerLevel = this.getJobLevel(jobName, user);
        int nextLevel = playerLevel + 1;
        int expToLevel = (int)((Math.pow(nextLevel, 2.0) + (double)nextLevel) / 2.0) * 100 - nextLevel * 100;
        return expToLevel;
    }

    public Text getJobList() {
        ArrayList texts = new ArrayList();
        this.jobsMap.forEach((jobName, jobObject) -> texts.add(Text.of((Object[])new Object[]{TextActions.runCommand((String)("/job set " + jobName)), TextActions.showText((Text)Text.of((String)"Click to change job")), jobName})));
        return Text.joinWith((Text)Text.of((String)", "), (Text[])texts.toArray(new Text[texts.size()]));
    }

    @Listener
    public void onJobSignCheck(ChangeSignEvent event) {
        SignData data = event.getText();
        Text lineOne = (Text)data.lines().get(0);
        Text lineTwo = (Text)data.lines().get(1);
        String lineOnePlain = lineOne.toPlain();
        String lineTwoPlain = lineTwo.toPlain();
        if (lineOnePlain.equals("[TEJobs]")) {
            lineOne = lineOne.toBuilder().style(new TextStyle[]{TextStyles.BOLD}).color(TextColors.DARK_BLUE).build();
            String jobName = this.titleize(lineTwoPlain);
            lineTwo = this.jobExists(lineTwoPlain) ? Text.of((String)jobName).toBuilder().color(TextColors.BLACK).build() : Text.of((String)jobName).toBuilder().color(TextColors.RED).build();
            data.set((BaseValue)data.lines().set(0, (Object)lineOne));
            data.set((BaseValue)data.lines().set(1, (Object)lineTwo));
            data.set((BaseValue)data.lines().set(2, (Object)Text.of()));
            data.set((BaseValue)data.lines().set(3, (Object)Text.of()));
        }
    }

    @Listener
    public void onSignInteract(InteractBlockEvent.Secondary event) {
        if (event.getCause().first(Player.class).isPresent()) {
            Sign sign;
            Optional data;
            TileEntity tileEntity;
            Optional tileEntityOpt;
            Player player = (Player)event.getCause().first(Player.class).get();
            if (event.getTargetBlock().getLocation().isPresent() && (tileEntityOpt = ((Location)event.getTargetBlock().getLocation().get()).getTileEntity()).isPresent() && (tileEntity = (TileEntity)tileEntityOpt.get()) instanceof Sign && (data = (sign = (Sign)tileEntity).getOrCreate(SignData.class)).isPresent()) {
                SignData signData = (SignData)data.get();
                Text lineOneText = (Text)signData.lines().get(0);
                Text lineTwoText = (Text)signData.lines().get(1);
                String lineOne = lineOneText.toPlain();
                String jobName = lineTwoText.toPlain().toLowerCase();
                if (lineOne.equals("[TEJobs]")) {
                    if (this.jobExists(jobName)) {
                        if (this.setJob((User)player, jobName)) {
                            HashMap<String, String> messageValues = new HashMap<String, String>();
                            messageValues.put("job", this.titleize(jobName));
                            player.sendMessage(this.messageManager.getMessage("jobs.sign", messageValues));
                        } else {
                            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Failed to set job. Contact your administrator."}));
                        }
                    } else {
                        player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Sorry, this job does not exist"}));
                    }
                }
            }
        }
    }

    @Listener
    public void onPlayerBlockBreak(ChangeBlockEvent.Break event) {
        if (event.getCause().first(Player.class).isPresent()) {
            Player player = (Player)event.getCause().first(Player.class).get();
            UUID playerUniqueId = player.getUniqueId();
            String playerJob = this.getPlayerJob((User)player);
            Optional<TEJob> optPlayerJob = this.getJob(playerJob, true);
            BlockState state = ((BlockSnapshot)((Transaction)event.getTransactions().get(0)).getOriginal()).getState();
            String blockName = state.getType().getName();
            Optional blockCreator = ((BlockSnapshot)((Transaction)event.getTransactions().get(0)).getOriginal()).getCreator();
            if (this.accountManager.getUserOption("totaleconomy:block-break-info", (User)player).orElse("0").equals("1")) {
                ArrayList traits = new ArrayList(state.getTraits());
                int count = traits.size();
                ArrayList traitTexts = new ArrayList(count);
                for (int i = 0; i < count; ++i) {
                    Object traitValue = state.getTraitValue((BlockTrait)traits.get(i)).orElse(null);
                    traitTexts.add(i, Text.of((Object[])new Object[]{((BlockTrait)traits.get(i)).getName(), Character.valueOf('='), traitValue != null ? traitValue.toString() : "null"}));
                }
                Text t = Text.of((Object[])new Object[]{TextColors.GRAY, "TRAITS:\n    ", Text.joinWith((Text)Text.of((String)",\n    "), (Text[])traitTexts.toArray(new Text[traits.size()]))});
                player.sendMessage(Text.of((Object[])new Object[]{"Block-Name: ", blockName}));
                player.sendMessage(t);
            }
            if (optPlayerJob.isPresent()) {
                Optional<Object> reward = Optional.empty();
                List<String> sets = optPlayerJob.get().getSets();
                for (String s : sets) {
                    Optional<TEJobSet> optSet = this.getJobSet(s);
                    if (!optSet.isPresent()) {
                        this.logger.warn("Job " + playerJob + " has the nonexistent set \"" + s + "\"");
                        continue;
                    }
                    Optional<TEAction> action = optSet.get().getActionFor("break", blockName);
                    if (!action.isPresent()) continue;
                    Optional<TEActionReward> currentReward = action.get().evaluateBreak(this.logger, state, blockCreator.orElse(null));
                    if (!reward.isPresent()) {
                        reward = currentReward;
                        continue;
                    }
                    if (!currentReward.isPresent() || currentReward.get().getExpReward() <= ((TEActionReward)reward.get()).getExpReward()) continue;
                    reward = currentReward;
                }
                if (reward.isPresent()) {
                    boolean notify;
                    Optional<Currency> currencyOpt;
                    BigDecimal payAmount = new BigDecimal(((TEActionReward)reward.get()).getMoneyReward());
                    TECurrency currency = this.totalEconomy.getDefaultCurrency();
                    if (((TEActionReward)reward.get()).getCurrencyId() != null && (currencyOpt = this.totalEconomy.getTECurrencyRegistryModule().getById("totaleconomy:" + ((TEActionReward)reward.get()).getCurrencyId())).isPresent()) {
                        currency = currencyOpt.get();
                    }
                    if (notify = this.getNotificationState(playerUniqueId)) {
                        this.notifyPlayerOfJobReward(player, payAmount, currency);
                    }
                    TEAccount playerAccount = (TEAccount)this.accountManager.getOrCreateAccount(player.getUniqueId()).get();
                    playerAccount.deposit(currency, payAmount, event.getCause());
                    int expAmount = ((TEActionReward)reward.get()).getExpReward();
                    this.addExp(player, expAmount);
                    this.checkForLevel(player);
                }
            }
        }
    }

    @Listener
    public void onPlayerPlaceBlock(ChangeBlockEvent.Place event) {
        if (event.getCause().first(Player.class).isPresent()) {
            Player player = (Player)event.getCause().first(Player.class).get();
            UUID playerUniqueId = player.getUniqueId();
            String playerJob = this.getPlayerJob((User)player);
            Optional<TEJob> optPlayerJob = this.getJob(playerJob, true);
            BlockState state = ((BlockSnapshot)((Transaction)event.getTransactions().get(0)).getFinal()).getState();
            String blockName = state.getType().getName();
            if (this.accountManager.getUserOption("totaleconomy:block-place-info", (User)player).orElse("0").equals("1")) {
                ArrayList traits = new ArrayList(state.getTraits());
                int count = traits.size();
                ArrayList traitTexts = new ArrayList(count);
                for (int i = 0; i < count; ++i) {
                    Object traitValue = state.getTraitValue((BlockTrait)traits.get(i)).orElse(null);
                    traitTexts.add(i, Text.of((Object[])new Object[]{((BlockTrait)traits.get(i)).getName(), Character.valueOf('='), traitValue != null ? traitValue.toString() : "null"}));
                }
                Text t = Text.of((Object[])new Object[]{TextColors.GRAY, "TRAITS:\n    ", Text.joinWith((Text)Text.of((String)",\n    "), (Text[])traitTexts.toArray(new Text[traits.size()]))});
                player.sendMessage(Text.of((Object[])new Object[]{"Block-Name: ", blockName}));
                player.sendMessage(t);
            }
            if (optPlayerJob.isPresent()) {
                Optional<Object> reward = Optional.empty();
                List<String> sets = optPlayerJob.get().getSets();
                for (String s : sets) {
                    Optional<TEJobSet> optSet = this.getJobSet(s);
                    if (!optSet.isPresent()) {
                        this.logger.warn("Job " + playerJob + " has the nonexistent set \"" + s + "\"");
                        continue;
                    }
                    Optional<TEAction> action = optSet.get().getActionFor("place", blockName);
                    if (!action.isPresent()) continue;
                    Optional<TEActionReward> currentReward = action.get().evaluatePlace(this.logger, state);
                    if (!reward.isPresent()) {
                        reward = currentReward;
                        continue;
                    }
                    if (!currentReward.isPresent() || currentReward.get().getExpReward() <= ((TEActionReward)reward.get()).getExpReward()) continue;
                    reward = currentReward;
                }
                if (reward.isPresent()) {
                    Optional<Currency> currencyOpt;
                    boolean notify = this.getNotificationState(playerUniqueId);
                    BigDecimal payAmount = new BigDecimal(((TEActionReward)reward.get()).getMoneyReward());
                    TECurrency currency = this.totalEconomy.getDefaultCurrency();
                    if (((TEActionReward)reward.get()).getCurrencyId() != null && (currencyOpt = this.totalEconomy.getTECurrencyRegistryModule().getById("totaleconomy:" + ((TEActionReward)reward.get()).getCurrencyId())).isPresent()) {
                        currency = currencyOpt.get();
                    }
                    if (notify) {
                        this.notifyPlayerOfJobReward(player, payAmount, currency);
                    }
                    TEAccount playerAccount = (TEAccount)this.accountManager.getOrCreateAccount(player.getUniqueId()).get();
                    playerAccount.deposit(currency, payAmount, event.getCause());
                    int expAmount = ((TEActionReward)reward.get()).getExpReward();
                    this.addExp(player, expAmount);
                    this.checkForLevel(player);
                }
            }
        }
    }

    @Listener
    public void onPlayerKillEntity(DestructEntityEvent.Death event) {
        Optional optDamageSource = event.getCause().first(EntityDamageSource.class);
        if (optDamageSource.isPresent()) {
            Optional damageCreator;
            EntityDamageSource damageSource = (EntityDamageSource)optDamageSource.get();
            Entity killer = damageSource.getSource();
            Living victim = event.getTargetEntity();
            if (!(killer instanceof Player) && (damageCreator = damageSource.getSource().getCreator()).isPresent()) {
                killer = (Entity)Sponge.getServer().getPlayer((UUID)damageCreator.get()).get();
            }
            if (killer instanceof Player) {
                Player player = (Player)killer;
                UUID playerUniqueId = player.getUniqueId();
                String victimName = victim.getType().getName();
                String playerJob = this.getPlayerJob((User)player);
                Optional<TEJob> optPlayerJob = this.getJob(playerJob, true);
                if (this.accountManager.getUserOption("totaleconomy:entity-kill-info", (User)player).orElse("0").equals("1")) {
                    player.sendMessage(Text.of((Object[])new Object[]{"Victim-Name: ", victimName}));
                }
                if (optPlayerJob.isPresent()) {
                    Optional<Object> reward = Optional.empty();
                    List<String> sets = optPlayerJob.get().getSets();
                    for (String s : sets) {
                        Optional<TEJobSet> optSet = this.getJobSet(s);
                        if (!optSet.isPresent()) {
                            this.logger.warn("Job " + playerJob + " has the nonexistent set \"" + s + "\"");
                            continue;
                        }
                        Optional<TEAction> action = optSet.get().getActionFor("kill", victimName);
                        if (!action.isPresent()) continue;
                        Optional<TEActionReward> currentReward = action.get().getReward();
                        if (!reward.isPresent()) {
                            reward = currentReward;
                            continue;
                        }
                        if (!currentReward.isPresent() || currentReward.get().getExpReward() <= ((TEActionReward)reward.get()).getExpReward()) continue;
                        reward = currentReward;
                    }
                    if (reward.isPresent()) {
                        Optional<Currency> currencyOpt;
                        boolean notify = this.getNotificationState(playerUniqueId);
                        BigDecimal payAmount = new BigDecimal(((TEActionReward)reward.get()).getMoneyReward());
                        TECurrency currency = this.totalEconomy.getDefaultCurrency();
                        if (((TEActionReward)reward.get()).getCurrencyId() != null && (currencyOpt = this.totalEconomy.getTECurrencyRegistryModule().getById("totaleconomy:" + ((TEActionReward)reward.get()).getCurrencyId())).isPresent()) {
                            currency = currencyOpt.get();
                        }
                        if (notify) {
                            this.notifyPlayerOfJobReward(player, payAmount, currency);
                        }
                        TEAccount playerAccount = (TEAccount)this.accountManager.getOrCreateAccount(player.getUniqueId()).get();
                        playerAccount.deposit(currency, payAmount, event.getCause());
                        int expAmount = ((TEActionReward)reward.get()).getExpReward();
                        this.addExp(player, expAmount);
                        this.checkForLevel(player);
                    }
                }
            }
        }
    }

    @Listener
    public void onPlayerFish(FishingEvent.Stop event) {
        if (event.getCause().first(Player.class).isPresent()) {
            if (event.getTransactions().size() == 0) {
                return;
            }
            Transaction itemTransaction = (Transaction)event.getTransactions().get(0);
            ItemStack itemStack = ((ItemStackSnapshot)itemTransaction.getFinal()).createStack();
            Player player = (Player)event.getCause().first(Player.class).get();
            UUID playerUniqueId = player.getUniqueId();
            String playerJob = this.getPlayerJob((User)player);
            Optional<TEJob> optPlayerJob = this.getJob(playerJob, true);
            if (optPlayerJob.isPresent() && itemStack.get(FishData.class).isPresent()) {
                FishData fishData = (FishData)itemStack.get(FishData.class).get();
                String fishName = ((Fish)fishData.type().get()).getName();
                if (this.accountManager.getUserOption("totaleconomy:entity-fish-info", (User)player).orElse("0").equals("1")) {
                    player.sendMessage(Text.of((Object[])new Object[]{"Fish-Name: ", fishName}));
                }
                Optional<Object> reward = Optional.empty();
                List<String> sets = optPlayerJob.get().getSets();
                for (String s : sets) {
                    Optional<TEJobSet> optSet = this.getJobSet(s);
                    if (!optSet.isPresent()) {
                        this.logger.warn("Job " + playerJob + " has the nonexistent set \"" + s + "\"");
                        continue;
                    }
                    Optional<TEAction> action = optSet.get().getActionFor("catch", fishName);
                    if (!action.isPresent()) continue;
                    Optional<TEActionReward> currentReward = action.get().getReward();
                    if (!reward.isPresent()) {
                        reward = currentReward;
                        continue;
                    }
                    if (!currentReward.isPresent() || currentReward.get().getExpReward() <= ((TEActionReward)reward.get()).getExpReward()) continue;
                    reward = currentReward;
                }
                if (reward.isPresent()) {
                    Optional<Currency> currencyOpt;
                    boolean notify = this.getNotificationState(playerUniqueId);
                    BigDecimal payAmount = new BigDecimal(((TEActionReward)reward.get()).getMoneyReward());
                    TECurrency currency = this.totalEconomy.getDefaultCurrency();
                    if (((TEActionReward)reward.get()).getCurrencyId() != null && (currencyOpt = this.totalEconomy.getTECurrencyRegistryModule().getById("totaleconomy:" + ((TEActionReward)reward.get()).getCurrencyId())).isPresent()) {
                        currency = currencyOpt.get();
                    }
                    if (notify) {
                        this.notifyPlayerOfJobReward(player, payAmount, currency);
                    }
                    TEAccount playerAccount = (TEAccount)this.accountManager.getOrCreateAccount(player.getUniqueId()).get();
                    playerAccount.deposit(currency, payAmount, event.getCause());
                    int expAmount = ((TEActionReward)reward.get()).getExpReward();
                    this.addExp(player, expAmount);
                    this.checkForLevel(player);
                }
            }
        }
    }
}

