/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import com.google.common.base.Predicate;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IComponent;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.EnumFacingUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DirectionalComponent
implements IBlockComponent {
    public static final PropertyDirection HORIZONTAL = PropertyDirection.func_177712_a((String)"direction", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyDirection ALL = PropertyDirection.func_177714_a((String)"direction");
    private IPlacement placement = IPlacement.PLACER;
    private PropertyDirection property = HORIZONTAL;

    public DirectionalComponent(PropertyDirection property, IPlacement placement) {
        this.property = property;
        this.placement = placement;
    }

    public DirectionalComponent() {
        this(HORIZONTAL, IPlacement.PLACER);
    }

    public DirectionalComponent(PropertyDirection property) {
        this(property, IPlacement.PLACER);
    }

    public DirectionalComponent(IPlacement placement) {
        this(HORIZONTAL, placement);
    }

    public PropertyDirection getProperty() {
        return this.property;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)EnumFacing.SOUTH);
    }

    public IBlockState placedState(IBlockState state, EnumFacing facing, EntityLivingBase placer) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)this.placement.getPlacement(state, facing, placer));
    }

    @Override
    public IBlockState getStateForPlacement(Block block, World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.placedState(state, facing, placer);
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        EnumFacing facing = null;
        facing = this.getProperty() == HORIZONTAL ? EnumFacing.func_176731_b((int)(meta & 3)) : EnumFacing.func_82600_a((int)(meta & 7));
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)facing);
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        if (this.getProperty() == HORIZONTAL) {
            return DirectionalComponent.getDirection(state).func_176736_b();
        }
        return DirectionalComponent.getDirection(state).func_176745_a();
    }

    public static EnumFacing getDirection(IBlockAccess world, BlockPos pos) {
        return world != null && pos != null ? DirectionalComponent.getDirection(world.func_180495_p(pos)) : EnumFacing.SOUTH;
    }

    public static EnumFacing getDirection(IBlockState state) {
        DirectionalComponent dc = IComponent.getComponent(DirectionalComponent.class, state.func_177230_c());
        if (dc == null) {
            return EnumFacing.SOUTH;
        }
        PropertyDirection property = dc.getProperty();
        if (property == null || !state.func_177228_b().containsKey((Object)property)) {
            return EnumFacing.SOUTH;
        }
        return (EnumFacing)state.func_177229_b((IProperty)property);
    }

    public static PropertyDirection getProperty(Block block) {
        DirectionalComponent dc = IComponent.getComponent(DirectionalComponent.class, block);
        return dc != null ? dc.getProperty() : null;
    }

    public static IBlockState rotate(IBlockState state) {
        return DirectionalComponent.rotate(state, 1);
    }

    public static IBlockState rotate(IBlockState state, int angle) {
        int a = -angle & 3;
        if (a == 0) {
            return state;
        }
        PropertyDirection property = DirectionalComponent.getProperty(state.func_177230_c());
        if (property == null || !state.func_177228_b().containsKey((Object)property)) {
            return state;
        }
        return state.func_177226_a((IProperty)property, (Comparable)EnumFacingUtils.rotateFacing((EnumFacing)state.func_177229_b((IProperty)property), a));
    }

    public static IBlockState getPlacedState(IBlockState state, EnumFacing facing, EntityLivingBase placer) {
        DirectionalComponent dc = IComponent.getComponent(DirectionalComponent.class, state.func_177230_c());
        return dc != null ? dc.placedState(state, facing, placer) : state;
    }

    public static interface IPlacement {
        public static final IPlacement BLOCKSIDE = (state, side, placer) -> side;
        public static final IPlacement PLACER = (state, side, placer) -> {
            EnumFacing facing = EntityUtils.getEntityFacing((Entity)placer, DirectionalComponent.getProperty(state.func_177230_c()) == ALL);
            return placer.func_70093_af() ? facing : facing.func_176734_d();
        };

        public EnumFacing getPlacement(IBlockState var1, EnumFacing var2, EntityLivingBase var3);
    }
}

