/*
 * Decompiled with CFR 0.152.
 */
package nc.gui.generator;

import com.google.common.collect.Lists;
import java.util.List;
import nc.config.NCConfig;
import nc.container.generator.ContainerFissionController;
import nc.gui.NCGui;
import nc.tile.energy.ITileEnergy;
import nc.tile.generator.TileFissionController;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.UnitHelper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class GuiFissionController
extends NCGui {
    protected TileFissionController tile;
    protected final ResourceLocation gui_textures;

    public GuiFissionController(EntityPlayer player, TileFissionController tile) {
        super(new ContainerFissionController(player, tile));
        this.tile = tile;
        this.gui_textures = new ResourceLocation("nuclearcraft:textures/gui/container/fission_controller.png");
        this.field_146999_f = 176;
        this.field_147000_g = 177;
    }

    @Override
    public void renderTooltips(int mouseX, int mouseY) {
        this.drawEnergyTooltip(this.tile, mouseX, mouseY, 8, 6, 6, 85);
        this.drawHeatTooltip(mouseX, mouseY, 18, 6, 6, 85);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int fontColor = this.tile.isProcessing ? -1 : (this.tile.complete == 1 ? 0xEEAA00 : 0xEE0000);
        String s = this.tile.complete == 1 ? this.tile.getLengthX() + "*" + this.tile.getLengthY() + "*" + this.tile.getLengthZ() + " " + Lang.localise("gui.container.fission_controller.reactor") : this.tile.problem;
        this.field_146289_q.func_78276_b(s, 8 + this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, fontColor);
        String s2 = this.tile.problemPos;
        this.field_146289_q.func_78276_b(s2, 8 + this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s2) / 2, 17, fontColor);
        String fuelName = this.tile.getFuelName();
        String fuel = fuelName.endsWith("OXIDE") ? fuelName.substring(0, fuelName.length() - 3) : fuelName;
        this.field_146289_q.func_78276_b(fuel, 28, this.field_147000_g - 104, fontColor);
        String cells = Lang.localise("gui.container.fission_controller.cells") + " " + this.tile.cells;
        this.field_146289_q.func_78276_b(cells, 28, this.field_147000_g - 93, fontColor);
        String power = UnitHelper.prefix((int)this.tile.processPower, 6, "RF/t");
        this.field_146289_q.func_78276_b(power, 170 - this.field_146289_q.func_78256_a(power), this.field_147000_g - 104, fontColor);
        String heatGen = UnitHelper.prefix((int)this.tile.heatChange, 6, "H/t");
        this.field_146289_q.func_78276_b(heatGen, 170 - this.field_146289_q.func_78256_a(heatGen), this.field_147000_g - 93, fontColor);
    }

    @Override
    public List<String> energyInfo(ITileEnergy tile) {
        String energy = UnitHelper.prefix((long)tile.getEnergyStorage().getEnergyStored(), (long)tile.getEnergyStorage().getMaxEnergyStored(), 6, "RF");
        String power = UnitHelper.prefix((int)this.tile.processPower, 6, "RF/t");
        String efficiency = NCMath.decimalPlaces(this.tile.efficiency, 1) + "%";
        if (this.tile.getFuelName().equals(TileFissionController.NO_FUEL) || this.tile.cells == 0) {
            return Lists.newArrayList((Object[])new String[]{TextFormatting.LIGHT_PURPLE + Lang.localise("gui.container.energy_stored") + TextFormatting.WHITE + " " + energy, TextFormatting.LIGHT_PURPLE + Lang.localise("gui.container.power_gen") + TextFormatting.WHITE + " " + power, TextFormatting.LIGHT_PURPLE + Lang.localise("gui.container.fission_controller.efficiency") + TextFormatting.WHITE + " " + efficiency});
        }
        double fuelTimeLeft = MathHelper.func_151237_a((double)((this.tile.baseProcessTime - this.tile.time) / ((double)this.tile.cells * NCConfig.fission_fuel_use)), (double)0.0, (double)(this.tile.baseProcessTime / NCConfig.fission_fuel_use));
        int fuelTimeLeftPercent = (int)(100.0 * MathHelper.func_151237_a((double)(1.0 - this.tile.time / this.tile.baseProcessTime), (double)0.0, (double)1.0));
        return Lists.newArrayList((Object[])new String[]{TextFormatting.LIGHT_PURPLE + Lang.localise("gui.container.energy_stored") + TextFormatting.WHITE + " " + energy, TextFormatting.LIGHT_PURPLE + Lang.localise("gui.container.power_gen") + TextFormatting.WHITE + " " + power, TextFormatting.LIGHT_PURPLE + Lang.localise("gui.container.fission_controller.efficiency") + TextFormatting.WHITE + " " + efficiency, TextFormatting.GREEN + Lang.localise("gui.container.fission_controller.fuel_remaining") + TextFormatting.WHITE + " " + UnitHelper.applyTimeUnitShort(fuelTimeLeft, 2) + " [" + fuelTimeLeftPercent + "%]"});
    }

    public List<String> heatInfo() {
        String heat = UnitHelper.prefix((long)((int)this.tile.heat), (long)this.tile.getMaxHeat(), 6, "H");
        String heatGen = UnitHelper.prefix((int)this.tile.heatChange, 6, "H/t");
        String cooling = UnitHelper.prefix((int)this.tile.cooling, 6, "H/t");
        String heatMult = NCMath.decimalPlaces(this.tile.heatMult, 1) + "%";
        return Lists.newArrayList((Object[])new String[]{TextFormatting.YELLOW + Lang.localise("gui.container.fission_controller.heat") + TextFormatting.WHITE + " " + heat, TextFormatting.YELLOW + Lang.localise("gui.container.fission_controller.heat_gen") + TextFormatting.WHITE + " " + heatGen, TextFormatting.BLUE + Lang.localise("gui.container.fission_controller.cooling") + TextFormatting.WHITE + " " + cooling, TextFormatting.YELLOW + Lang.localise("gui.container.fission_controller.heat_mult") + TextFormatting.WHITE + " " + heatMult});
    }

    public void drawHeatTooltip(int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(this.heatInfo(), mouseX, mouseY, x, y, width, height);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.gui_textures);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        double e = Math.round((double)this.tile.getEnergyStorage().getEnergyStored() / (double)this.tile.getEnergyStorage().getMaxEnergyStored() * 85.0);
        this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 6 + 85 - (int)e, 176, 175 - (int)e, 6, (int)e);
        double h = Math.round(this.tile.heat / (double)this.tile.getMaxHeat() * 85.0);
        this.func_73729_b(this.field_147003_i + 18, this.field_147009_r + 6 + 85 - (int)h, 182, 175 - (int)h, 6, (int)h);
        int k = this.getCookProgressScaled(37.0);
        this.func_73729_b(this.field_147003_i + 74, this.field_147009_r + 35, 176, 3, k, 16);
    }

    protected int getCookProgressScaled(double pixels) {
        double i = this.tile.time;
        double j = this.tile.baseProcessTime;
        return j != 0.0 ? (int)Math.round(i * pixels / j) : 0;
    }
}

