/*
 * Decompiled with CFR 0.152.
 */
package nc.network.gui;

import io.netty.buffer.ByteBuf;
import nc.NuclearCraft;
import nc.tile.IGui;
import nc.util.NCUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class OpenGuiPacket
implements IMessage {
    boolean messageValid;
    BlockPos pos;
    int guiID = -1;

    public OpenGuiPacket() {
        this.messageValid = false;
    }

    public OpenGuiPacket(BlockPos pos, int guiID) {
        this.pos = pos;
        this.guiID = guiID;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.guiID = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            NCUtil.getLogger().catching((Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.guiID);
    }

    public static class Handler
    implements IMessageHandler<OpenGuiPacket, IMessage> {
        public IMessage onMessage(OpenGuiPacket message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(OpenGuiPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)NuclearCraft.instance, (int)message.guiID, (World)player.func_71121_q(), (int)message.pos.func_177958_n(), (int)message.pos.func_177956_o(), (int)message.pos.func_177952_p());
            TileEntity tile = player.func_71121_q().func_175625_s(message.pos);
            if (tile instanceof IGui) {
                ((IGui)tile).beginUpdatingPlayer((EntityPlayer)player);
            }
        }
    }
}

