/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.wind.worlds;

import ic2.api.classic.wind.IWindHandlerInfo;
import ic2.api.classic.wind.IWindStream;
import ic2.core.IC2;
import ic2.core.platform.wind.misc.RealisticWindProperty;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WindHandlerRealisticOverworld
implements IWindHandlerInfo {
    World world;
    List<RealisticWindProperty> streams = new ArrayList<RealisticWindProperty>();

    public WindHandlerRealisticOverworld(World par1) {
        this.world = par1;
        int stream = IC2.config.getInt("maxWindStreams");
        for (int i = 0; i <= stream; ++i) {
            this.streams.add(new RealisticWindProperty(this.world));
        }
    }

    @Override
    public void onTick() {
        for (RealisticWindProperty stream : this.streams) {
            stream.onTick(this.world);
        }
    }

    @Override
    public double getWindStrenght(BlockPos pos, float rotation, float angle) {
        if (this.isVertical(angle)) {
            return 0.0;
        }
        double verticalEffect = this.getVerticalEffect(angle);
        double resultSpeed = 0.0;
        boolean count = false;
        for (RealisticWindProperty stream : this.streams) {
            float streamRotation = stream.getRotation();
            if (!stream.isInRange(pos.func_177956_o()) || this.isNotEffected(streamRotation, rotation)) continue;
            double speed = stream.getSpeed();
            speed *= stream.getRangeEffect(pos.func_177956_o());
            speed *= verticalEffect;
            if (this.isInverted(streamRotation, rotation)) {
                speed *= this.getEffect(this.angularDifference(this.rotate(streamRotation, 180.0f), rotation));
                speed = -speed;
            } else {
                speed *= this.getEffect(this.angularDifference(streamRotation, rotation));
            }
            resultSpeed += speed;
        }
        if (count > true) {
            resultSpeed /= (double)count;
        }
        return resultSpeed;
    }

    public double getEffect(double distance) {
        return 1.0 - distance / 90.0;
    }

    public boolean isInverted(float from, float rotation) {
        return this.isInDistance(this.rotate(from, 180.0f), rotation, 89.0f);
    }

    public float rotate(float toRotate, float adding) {
        if ((toRotate += adding) < 0.0f) {
            toRotate += 360.0f;
        } else if (toRotate > 360.0f) {
            toRotate -= 360.0f;
        }
        return toRotate;
    }

    private boolean isNotEffected(float windRot, float rotation) {
        float left = this.rotate(windRot, 90.0f);
        float right = this.rotate(windRot, -90.0f);
        return this.isInDistance(left, rotation, 5.0f) || this.isInDistance(right, windRot, 5.0f);
    }

    private boolean isInDistance(float from, float to, float range) {
        return this.angularDifference(from, to) < (double)range;
    }

    private double angularDifference(float alpha, float beta) {
        double d = Math.abs(alpha - beta);
        return Math.min(360.0 - d, d);
    }

    private boolean isVertical(float angle) {
        return angle >= 355.0f || angle <= 5.0f || angle >= 175.0f && angle <= 185.0f;
    }

    private double getVerticalEffect(float angle) {
        if (angle < 90.0f) {
            return (double)angle / 90.0;
        }
        if (angle > 270.0f) {
            return 1.0 - (double)(angle -= 270.0f) / 90.0;
        }
        if (angle > 180.0f) {
            return (double)(angle -= 180.0f) / 90.0;
        }
        return 1.0 - (double)(angle -= 90.0f) / 90.0;
    }

    @Override
    public double getMaxWind() {
        return 108.0;
    }

    @Override
    public List<IWindStream> getStreams() {
        return new ArrayList<IWindStream>(this.streams);
    }

    @Override
    public void onUnloaded() {
        this.streams.clear();
        this.world = null;
    }
}

