/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.commands;

import com.gmail.trentech.pjc.help.Help;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.storage.WorldProperties;

public class CommandModifier
implements CommandCallable {
    private final Help help = (Help)Help.get((String)"world modifier").get();

    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        String mod;
        String worldName;
        if (arguments.equalsIgnoreCase("modifier")) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        String[] args = arguments.split(" ");
        if (args[args.length - 1].equalsIgnoreCase("--help")) {
            this.help.execute(source);
            return CommandResult.success();
        }
        try {
            worldName = args[0];
        }
        catch (Exception e) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        Optional optionalWorld = Sponge.getServer().getWorldProperties(worldName);
        if (!optionalWorld.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, worldName, " does not exist"}), false);
        }
        WorldProperties world = (WorldProperties)optionalWorld.get();
        Collection modifiers = world.getGeneratorModifiers();
        try {
            mod = args[1];
        }
        catch (Exception e) {
            ArrayList<Text> list = new ArrayList<Text>();
            for (WorldGeneratorModifier modifier : modifiers) {
                list.add(Text.of((Object[])new Object[]{TextColors.WHITE, modifier.getId()}));
            }
            if (source instanceof Player) {
                PaginationList.Builder pages = PaginationList.builder();
                pages.title(Text.builder().color(TextColors.DARK_GREEN).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Current Modifiers"})}).build());
                pages.contents(list);
                pages.sendTo((MessageReceiver)source);
            } else {
                for (Text text : list) {
                    source.sendMessage(text);
                }
            }
            return CommandResult.success();
        }
        Optional optionalModifier = Sponge.getRegistry().getType(WorldGeneratorModifier.class, mod);
        if (!optionalModifier.isPresent()) {
            source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, mod, " is not a valid WorldGeneratorModifier"}));
            throw new CommandException(this.getHelp().getUsageText());
        }
        WorldGeneratorModifier modifier = (WorldGeneratorModifier)optionalModifier.get();
        try {
            if (!args[2].equalsIgnoreCase("-r")) {
                throw new CommandException(this.getHelp().getUsageText());
            }
            modifiers.remove(modifier);
            world.setGeneratorModifiers(modifiers);
            source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Removed modifier ", modifier.getId(), " to ", world.getWorldName()}));
        }
        catch (Exception e) {
            modifiers.add(modifier);
            world.setGeneratorModifiers(modifiers);
            source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Added modifier ", modifier.getId(), " to ", world.getWorldName()}));
        }
        return CommandResult.success();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, Location<World> targetPosition) throws CommandException {
        ArrayList<String> list = new ArrayList<String>();
        if (arguments.equalsIgnoreCase("modifier")) {
            return list;
        }
        String[] args = arguments.split(" ");
        if (args.length == 1) {
            for (WorldProperties world : Sponge.getServer().getAllWorldProperties()) {
                if (world.getWorldName().equalsIgnoreCase(args[0])) {
                    for (WorldGeneratorModifier modifier : Sponge.getRegistry().getAllOf(WorldGeneratorModifier.class)) {
                        list.add(modifier.getId());
                    }
                    return list;
                }
                if (!world.getWorldName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(world.getWorldName());
            }
        }
        if (args.length >= 2) {
            for (WorldGeneratorModifier modifier : Sponge.getRegistry().getAllOf(WorldGeneratorModifier.class)) {
                if (modifier.getId().equalsIgnoreCase(args[1])) {
                    return list;
                }
                if (!modifier.getId().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                list.add(modifier.getId());
            }
        }
        return list;
    }

    public boolean testPermission(CommandSource source) {
        Optional permission = this.getHelp().getPermission();
        if (permission.isPresent()) {
            return source.hasPermission((String)permission.get());
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Text getUsage(CommandSource source) {
        return this.getHelp().getUsageText();
    }

    public Help getHelp() {
        return this.help;
    }
}

