/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.nbt;

import java.util.ArrayList;
import java.util.List;
import me.lucko.luckperms.lib.adventure.nbt.BinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.BinaryTagType;
import me.lucko.luckperms.lib.adventure.nbt.BinaryTagTypes;
import me.lucko.luckperms.lib.adventure.nbt.ListBinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.ListBinaryTagImpl;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;

final class ListTagBuilder<T extends BinaryTag>
implements ListBinaryTag.Builder<T> {
    private @MonotonicNonNull List<BinaryTag> tags;
    private BinaryTagType<? extends BinaryTag> type;

    ListTagBuilder() {
        this(BinaryTagTypes.END);
    }

    ListTagBuilder(BinaryTagType<? extends BinaryTag> type) {
        this.type = type;
    }

    @Override
    public @NonNull ListBinaryTag.Builder<T> add(BinaryTag tag) {
        ListBinaryTagImpl.noAddEnd(tag);
        if (this.type == BinaryTagTypes.END) {
            this.type = tag.type();
        }
        ListBinaryTagImpl.mustBeSameType(tag, this.type);
        if (this.tags == null) {
            this.tags = new ArrayList<BinaryTag>();
        }
        this.tags.add(tag);
        return this;
    }

    @Override
    public @NonNull ListBinaryTag build() {
        if (this.tags == null) {
            return ListBinaryTag.empty();
        }
        return new ListBinaryTagImpl(this.type, new ArrayList<BinaryTag>(this.tags));
    }
}

