/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.api.tile.ITileEffects;
import galaxyspace.core.GSItems;
import galaxyspace.core.prefab.tile.TileEntityUpgradeMachine;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.machines.BlockGasCollector;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityGasCollector
extends TileEntityUpgradeMachine
implements ITileEffects,
ISidedInventory,
IFluidHandlerWrapper,
IPacketReceiver {
    private int PROCESS_TIME_REQUIRED;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired;
    private final int tankCapacity = 5000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank gasTank;
    private boolean visible;
    private int radius;
    private int drainX;
    private int drainY;
    private int drainZ;

    public TileEntityGasCollector() {
        super("tile.gas_collector.name");
        this.processTimeRequired = this.PROCESS_TIME_REQUIRED = 30;
        this.tankCapacity = 5000;
        this.gasTank = new FluidTank(this.tankCapacity);
        this.visible = false;
        this.radius = 2;
        this.drainX = -this.radius;
        this.drainY = 0;
        this.drainZ = -this.radius;
        this.storage.setCapacity(20000.0f);
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 60.0f : 45.0f);
        this.inventory = NonNullList.func_191197_a((int)7, (Object)ItemStack.field_190927_a);
        this.setTierGC(1);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.radius = 2;
        if (this.upgradeSlots() != null) {
            for (int i = 0; i <= this.upgradeSlots().length - 1; ++i) {
                if (!((ItemStack)this.getInventory().get(this.upgradeSlots()[i])).func_77969_a(new ItemStack(GSItems.UPGRADES, 1, 0))) continue;
                this.radius += 2;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            GSUtils.checkFluidTankTransfer((NonNullList<ItemStack>)this.getInventory(), 1, this.gasTank);
            if (this.canProcess() && this.hasEnoughEnergyToRun) {
                if (this.processTicks >= this.processTimeRequired) {
                    this.smeltItem();
                    this.processTicks = 0;
                }
            } else {
                this.processTicks = 0;
            }
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.visible) {
                int xMin = -this.radius;
                int xMax = this.radius + 1;
                int zMin = -this.radius;
                int zMax = this.radius + 1;
                for (int x = xMin; x <= xMax; ++x) {
                    for (int z = zMin; z <= zMax; ++z) {
                        for (int y = 0; y <= this.radius + 1; ++y) {
                            if (y == 0 || y == this.radius + 1) {
                                if (x != xMin && x != xMax && z != zMin && z != zMax) continue;
                                this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, (double)(this.func_174877_v().func_177958_n() + x), (double)(this.func_174877_v().func_177956_o() + y), (double)(this.func_174877_v().func_177952_p() + z), 0.0, 0.0, 0.0, new int[0]);
                                continue;
                            }
                            if (x != xMin && x != xMax || z != zMin && z != zMax) continue;
                            this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, (double)(this.func_174877_v().func_177958_n() + x), (double)(this.func_174877_v().func_177956_o() + y), (double)(this.func_174877_v().func_177952_p() + z), 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                }
            }
            if (this.canProcess() && this.ticks % 10 == 0 && this.hasEnoughEnergyToRun) {
                for (int particleCount = 0; particleCount < 50; ++particleCount) {
                    double x2 = (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
                    double y2 = (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat() + 1.0f;
                    double z2 = (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
                    double mX = 0.0;
                    double mY = 0.0;
                    double mZ = 0.0;
                    int dir = this.field_145850_b.field_73012_v.nextInt(2) * 2 - 1;
                    mX = ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5) * 0.5;
                    mY = ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5) * 0.5;
                    mZ = ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5) * 0.5;
                    z2 = (double)this.field_174879_c.func_177952_p() + 0.5 + 0.25 * (double)dir;
                    mZ = this.field_145850_b.field_73012_v.nextFloat() * 2.0f * (float)dir;
                    GalacticraftCore.proxy.spawnParticle("oxygen", new Vector3(x2, y2, z2), new Vector3(mX, mY, mZ), new Object[]{new Vector3(0.8, 0.7, 0.6)});
                }
            }
        }
    }

    @Override
    public boolean canProcess() {
        if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a()).func_185913_b()) {
            return false;
        }
        if (this.gasTank.getFluidAmount() >= this.gasTank.getCapacity()) {
            return false;
        }
        return !this.func_70301_a(2).func_190926_b();
    }

    public void smeltItem() {
        BlockPos pos = this.func_174877_v().func_177982_a(this.drainX, this.drainY, this.drainZ);
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        Block block = state.func_177230_c();
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == 0) {
            if (block instanceof BlockFluidClassic) {
                Fluid fluid = ((BlockFluidClassic)block).getFluid();
                if (!fluid.isGaseous()) {
                    return;
                }
                this.gasTank.fill(new FluidStack(fluid, 1000), true);
                if (this.gasTank.getFluid().isFluidEqual(new FluidStack(FluidRegistry.lookupFluidForBlock((Block)block), 0))) {
                    this.field_145850_b.func_175698_g(pos);
                }
                return;
            }
            if (block instanceof IFluidBlock) {
                IFluidBlock fluid = (IFluidBlock)block;
                if (!fluid.getFluid().isGaseous()) {
                    return;
                }
                this.gasTank.fill(new FluidStack(fluid.getFluid(), 1000), true);
                if (this.gasTank.getFluid().isFluidEqual(new FluidStack(FluidRegistry.lookupFluidForBlock((Block)block), 0))) {
                    this.field_145850_b.func_175698_g(pos);
                }
                return;
            }
        }
        if (this.drainX++ == this.radius) {
            ++this.drainZ;
            this.drainX = -this.radius;
        }
        if (this.drainZ == this.radius + 1) {
            ++this.drainY;
            this.drainZ = -this.radius;
        }
        if (this.drainY == this.radius + 1) {
            this.drainY = 0;
            this.drainX = -this.radius;
            this.drainZ = -this.radius;
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        ItemStackHelper.func_191283_b((NBTTagCompound)par1NBTTagCompound, (NonNullList)this.getInventory());
        this.radius = par1NBTTagCompound.func_74762_e("radius");
        if (par1NBTTagCompound.func_74764_b("gasTank")) {
            this.gasTank.readFromNBT(par1NBTTagCompound.func_74775_l("gasTank"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        super.func_189515_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        par1NBTTagCompound.func_74768_a("radius", this.radius);
        ItemStackHelper.func_191282_a((NBTTagCompound)par1NBTTagCompound, (NonNullList)this.getInventory());
        if (this.gasTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("gasTank", (NBTBase)this.gasTank.writeToNBT(new NBTTagCompound()));
        }
        return par1NBTTagCompound;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return slotID == 0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
            }
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int[] upgradeSlots() {
        return new int[]{3, 4, 5, 6};
    }

    public EnumFacing getElectricInputDirection() {
        return EnumFacing.DOWN;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockGasCollector) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockGasCollector.FACING);
        }
        return EnumFacing.NORTH;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (from == this.getPipe() && resource != null && resource.isFluidEqual(this.gasTank.getFluid())) {
            return this.gasTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (from == this.getPipe()) {
            return this.gasTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (from == this.getPipe()) {
            return this.gasTank.getFluid() != null && this.gasTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.gasTank)};
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    private EnumFacing getPipe() {
        return this.getFront().func_176735_f();
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        if (type == NetworkType.FLUID) {
            EnumFacing pipeSide = this.getPipe();
            return direction == pipeSide;
        }
        return false;
    }

    public int getScaledTankLevel(int i) {
        return this.gasTank.getFluidAmount() * i / this.gasTank.getCapacity();
    }

    @Override
    public void setEffectsVisible(boolean shouldRender) {
        this.visible = shouldRender;
    }

    @Override
    public boolean getEffectsVisible() {
        return this.visible;
    }
}

