/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.event;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.api.item.IItemPressurized;
import asmodeuscore.api.space.IExBody;
import asmodeuscore.core.astronomy.BodiesData;
import asmodeuscore.core.astronomy.BodiesRegistry;
import asmodeuscore.core.astronomy.gui.overlay.OverlayDetectors;
import asmodeuscore.core.astronomy.gui.screen.AC_GuiCelestialSelection;
import asmodeuscore.core.astronomy.gui.screen.NewGuiCelestialSelection;
import asmodeuscore.core.astronomy.sky.CloudProviderBase;
import asmodeuscore.core.astronomy.sky.CustomCloudRender;
import asmodeuscore.core.astronomy.sky.galacticraft.SkyProviderAsteroids;
import asmodeuscore.core.astronomy.sky.galacticraft.SkyProviderMoon;
import asmodeuscore.core.astronomy.sky.galacticraft.SkyProviderOverworld;
import asmodeuscore.core.configs.AsmodeusConfig;
import asmodeuscore.core.utils.ACAttributePlayer;
import asmodeuscore.core.utils.ACCompatibilityManager;
import asmodeuscore.core.utils.Utils;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.venus.dimension.WorldProviderVenus;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AsmodeusClientEvent {
    public Minecraft mc = FMLClientHandler.instance().getClient();
    public static boolean inOxygenBlock = false;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenEvent(GuiOpenEvent event) {
        if (ACCompatibilityManager.isGalacticraftLoaded() && event.getGui() instanceof GuiCelestialSelection && AsmodeusConfig.enableNewGalaxyMap) {
            GameSettings cfr_ignored_0 = this.mc.field_71474_y;
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.galaxyMap)) {
                event.setGui((GuiScreen)new NewGuiCelestialSelection(true, null, false, null));
            }
            GameSettings cfr_ignored_1 = this.mc.field_71474_y;
            if (GameSettings.func_100015_a((KeyBinding)this.mc.field_71474_y.field_74311_E)) {
                GameSettings cfr_ignored_2 = this.mc.field_71474_y;
                if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.galaxyMap)) {
                    event.setGui((GuiScreen)new AC_GuiCelestialSelection(true, null, false));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        WorldClient world = this.mc.field_71441_e;
        if (world != null) {
            IRenderHandler clouds;
            if (world.field_73011_w.getCloudRenderer() instanceof CloudProviderBase && !this.mc.func_147113_T()) {
                clouds = (CloudProviderBase)world.field_73011_w.getCloudRenderer();
                clouds.cloudTicksPrev = clouds.cloudTicks;
                clouds.cloudTicks = (long)((float)clouds.cloudTicks + clouds.getCloudMovementSpeed((World)world));
            }
            if (world.field_73011_w.getCloudRenderer() instanceof CustomCloudRender && !this.mc.func_147113_T()) {
                clouds = (CustomCloudRender)world.field_73011_w.getCloudRenderer();
                clouds.cloudTicksPrev = clouds.cloudTicks;
                clouds.cloudTicks = (long)((float)clouds.cloudTicks + clouds.getCloudMovementSpeed(world));
            }
            if (world.field_73011_w.getDimension() == 0 && AsmodeusConfig.enableSkyOverworld && !(world.field_73011_w.getSkyRenderer() instanceof SkyProviderOverworld)) {
                world.field_73011_w.setSkyRenderer((IRenderHandler)new SkyProviderOverworld());
            }
            if (world.field_73011_w instanceof WorldProviderMoon && AsmodeusConfig.enableSkyMoon && !(world.field_73011_w.getSkyRenderer() instanceof SkyProviderMoon)) {
                world.field_73011_w.setSkyRenderer((IRenderHandler)new SkyProviderMoon());
            }
            if (world.field_73011_w instanceof WorldProviderAsteroids && AsmodeusConfig.enableSkyAsteroids && !(world.field_73011_w.getSkyRenderer() instanceof SkyProviderAsteroids)) {
                world.field_73011_w.setSkyRenderer((IRenderHandler)new SkyProviderAsteroids());
            }
            if (world.field_73011_w instanceof WorldProviderVenus && AsmodeusConfig.enableCloudsVenus && !(world.field_73011_w.getCloudRenderer() instanceof CustomCloudRender)) {
                float[] f = new float[]{1.0f, 4.0f, 8.0f};
                world.field_73011_w.setCloudRenderer((IRenderHandler)new CustomCloudRender(f){

                    @Override
                    public ResourceLocation getCloudTexture() {
                        return this.default_clouds;
                    }

                    @Override
                    public Vec3d getCloudColor(float renderPartialTicks) {
                        return new Vec3d(81.0, 61.0, 0.0);
                    }

                    @Override
                    public float getCloudMovementSpeed(WorldClient world) {
                        return 3.0f;
                    }
                });
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!ACCompatibilityManager.isGalacticraftLoaded()) {
            return;
        }
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, (boolean)false);
        float level = 0.0f;
        if (event.phase == TickEvent.Phase.END && player != null && player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && OxygenUtil.shouldDisplayTankGui((GuiScreen)minecraft.field_71462_r) && !playerBaseClient.func_175149_v() && !minecraft.field_71474_y.field_74330_P) {
            IGalacticraftWorldProvider provider = (IGalacticraftWorldProvider)player.field_70170_p.field_73011_w;
            BodiesData data = BodiesRegistry.getData(provider.getCelestialBody());
            GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)player);
            if (provider.getCelestialBody() instanceof IExBody && !minecraft.field_71439_g.func_184812_l_()) {
                level = ((IExBody)provider.getCelestialBody()).getAtmosphericPressure();
                if (level != 0.0f) {
                    OverlayDetectors.renderPressureIndicator(level, this.getInvalidLevel(1, level), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
                }
                if (((IExBody)provider.getCelestialBody()).isSolarRadiation()) {
                    OverlayDetectors.renderRadiationIndicator((int)player.func_110148_a(ACAttributePlayer.RADIATION_LVL).func_111126_e(), this.getInvalidLevel(2, level), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
                }
                if (((IExBody)provider.getCelestialBody()).getWaterPressure() > 0.0f && Utils.inWater((EntityPlayer)player)) {
                    float i = 0.0f;
                    int blocks = 0;
                    while (player.field_70170_p.func_180495_p(player.func_180425_c().func_177981_b(blocks)).func_185904_a() != Material.field_151579_a) {
                        i = (float)((double)i + 0.1 * (double)((IExBody)provider.getCelestialBody()).getWaterPressure());
                        ++blocks;
                    }
                    OverlayDetectors.renderWaterPressureIndicator(i, this.getInvalidLevel(3, i), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
                }
            } else {
                if (data != null) {
                    level = data.getPressure();
                }
                if (level != 0.0f) {
                    OverlayDetectors.renderPressureIndicator(level, this.getInvalidLevel(1, level), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
                }
                if (data != null && data.isSolarRadiation()) {
                    OverlayDetectors.renderRadiationIndicator((int)player.func_110148_a(ACAttributePlayer.RADIATION_LVL).func_111126_e(), this.getInvalidLevel(2, level), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
                }
            }
            float mod = provider.getThermalLevelModifier();
            if (player.field_70170_p.field_73011_w instanceof IAdvancedSpace) {
                mod = ((IAdvancedSpace)provider).getThermalLevelModifier((EntityPlayer)player);
            }
            if (mod > 0.0f) {
                mod += 1.0f;
            }
            float temp = mod * (float)BodiesRegistry.getDefaultDergrees;
            OverlayDetectors.renderInfoPanel(temp, this.getInvalidLevel(2, level), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
        }
    }

    private boolean getInvalidLevel(int mode, float level) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        return mode == 1 ? level > 25.0f && !AsmodeusClientEvent.getAtmoArmor((EntityPlayer)player) : (mode == 2 ? player.func_110148_a(ACAttributePlayer.RADIATION_LVL).func_111126_e() > 45.0 : mode == 3 && level > 40.0f && !AsmodeusClientEvent.getAtmoArmor((EntityPlayer)player));
    }

    public static boolean getAtmoArmor(EntityPlayer player) {
        for (int i = 0; i < 3; ++i) {
            if (!player.field_71071_by.func_70440_f(i).func_190926_b() && player.field_71071_by.func_70440_f(i).func_77973_b() instanceof IItemPressurized) continue;
            return false;
        }
        return true;
    }
}

