/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableMap;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.util.PaginationBuilderWrapper;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.InventoryTransformations;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.entity.MainPlayerInventory;
import org.spongepowered.api.item.inventory.property.InventoryDimension;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class Util {
    public static final DateTimeFormatter FULL_TIME_FORMATTER = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL).withZone(ZoneId.systemDefault());
    public static final Text SPACE = Text.of((String)" ");
    private static final TextTemplate CHAT_TEMPLATE = TextTemplate.of((Object[])new Object[]{TextTemplate.arg((String)"header").build(), TextTemplate.arg((String)"body").build(), TextTemplate.arg((String)"footer").build()});
    public static final String usernameRegexPattern = "[0-9a-zA-Z_]{3,16}";
    public static final Pattern usernameRegex = Pattern.compile("[0-9a-zA-Z_]{3,16}");
    public static final UUID CONSOLE_FAKE_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");

    private Util() {
    }

    public static CommandSource getSourceFromCause(Cause cause) {
        return cause.first(CommandSource.class).orElseGet(() -> ((Server)Sponge.getServer()).getConsole());
    }

    public static Text applyChatTemplate(MessageEvent.MessageFormatter formatter) {
        return Util.applyChatTemplate((TextRepresentable)formatter.getHeader(), (TextRepresentable)formatter.getBody(), (TextRepresentable)formatter.getFooter());
    }

    public static Text applyChatTemplate(TextRepresentable header, TextRepresentable body, TextRepresentable footer) {
        return CHAT_TEMPLATE.apply((Map)ImmutableMap.of((Object)"header", (Object)header, (Object)"body", (Object)body, (Object)"footer", (Object)footer)).build();
    }

    public static UUID getUUID(CommandSource src) {
        if (src instanceof Identifiable) {
            return ((Identifiable)src).getUniqueId();
        }
        return CONSOLE_FAKE_UUID;
    }

    public static Optional<User> getUserFromUUID(UUID uuid) {
        return ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(uuid).map(x -> x.isOnline() ? (User)x.getPlayer().get() : x);
    }

    public static Object getObjectFromUUID(UUID uuid) {
        Optional<Object> user = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(uuid).map(x -> x.isOnline() ? x.getPlayer().get() : x);
        return user.orElseGet(() -> Sponge.getServer().getConsole());
    }

    public static String getNameOrUnkown(ICommandContext<? extends CommandSource> context, GameProfile profile) {
        return profile.getName().orElse(context.getServiceCollection().messageProvider().getMessageString("standard.unknown", new Object[0]));
    }

    public static String getTimeFromTicks(IMessageProviderService messageProviderService, long ticks) {
        if (ticks < 0L || ticks > 23999L) {
            ticks %= 24000L;
        }
        int mins = (int)((double)(ticks % 1000L) / 16.666666666666668);
        long hours = (ticks / 1000L + 6L) % 24L;
        NumberFormat m = NumberFormat.getIntegerInstance();
        m.setMinimumIntegerDigits(2);
        if (hours < 12L) {
            long ahours = hours == 0L ? 12L : hours;
            return messageProviderService.getMessageString("standard.time.am", ahours, hours, m.format(mins));
        }
        long ahours = (hours -= 12L) == 0L ? 12L : hours;
        return messageProviderService.getMessageString("standard.time.pm", ahours, hours, m.format(mins));
    }

    public static <T extends Translatable & CatalogType> String getTranslatableIfPresent(T translatable) {
        try {
            String result = translatable.getTranslation().get();
            if (!result.isEmpty()) {
                return result;
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        return ((CatalogType)translatable).getName();
    }

    public static Optional<String> getKeyIgnoreCase(Map<String, ?> map, String key) {
        return Util.getKeyIgnoreCase(map.keySet(), key);
    }

    public static Optional<String> getKeyIgnoreCase(Collection<String> collection, String key) {
        return collection.stream().filter(x -> x.equalsIgnoreCase(key)).findFirst();
    }

    public static <T> Optional<T> getValueIgnoreCase(Map<String, T> map, String key) {
        return map.entrySet().stream().filter(x -> ((String)x.getKey()).equalsIgnoreCase(key)).map(Map.Entry::getValue).findFirst();
    }

    public static boolean isLocationInWorldBorder(Location<World> location) {
        return Util.isLocationInWorldBorder(location.getPosition(), (World)location.getExtent());
    }

    public static boolean isLocationInWorldBorder(Vector3d location, World world) {
        long radius = (long)Math.floor(world.getWorldBorder().getDiameter() / 2.0);
        Vector3d displacement = location.sub(world.getWorldBorder().getCenter()).abs();
        return !(displacement.getX() > (double)radius) && !(displacement.getZ() > (double)radius);
    }

    public static void compressAndDeleteFile(Path from) throws IOException {
        if (Files.exists(from, new LinkOption[0])) {
            Path to = Paths.get(from.toString() + ".gz", new String[0]);
            try (GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(to.toFile()));){
                Files.copy(from, os);
                ((OutputStream)os).flush();
                Files.delete(from);
            }
        }
    }

    public static PaginationList.Builder getPaginationBuilder(CommandSource source) {
        return Util.getPaginationBuilder(source instanceof Player);
    }

    public static PaginationList.Builder getPaginationBuilder(boolean isPlayer) {
        PaginationList.Builder plb = ((PaginationService)Sponge.getServiceManager().provideUnchecked(PaginationService.class)).builder();
        if (!isPlayer) {
            plb.linesPerPage(-1);
        }
        return new PaginationBuilderWrapper(plb);
    }

    public static Inventory.Builder getKitInventoryBuilder() {
        return Inventory.builder().of(InventoryArchetypes.CHEST).property("inventorydimension", (InventoryProperty)new InventoryDimension(9, 4));
    }

    public static Optional<CatalogType> getTypeFromItemInHand(Player src) {
        if (src.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
            return Optional.of(Util.getTypeFromItem((ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).get()));
        }
        return Optional.empty();
    }

    public static CatalogType getTypeFromItem(ItemStack is) {
        try {
            Optional blockState = is.get(Keys.ITEM_BLOCKSTATE);
            if (blockState.isPresent()) {
                return (CatalogType)blockState.get();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return is.getType();
    }

    public static ItemStack dropItemOnFloorAtLocation(ItemStackSnapshot itemStackSnapshotToDrop, Location<World> location) {
        return Util.dropItemOnFloorAtLocation(itemStackSnapshotToDrop, (World)location.getExtent(), location.getPosition());
    }

    public static ItemStack dropItemOnFloorAtLocation(ItemStackSnapshot itemStackSnapshotToDrop, World world, Vector3d position) {
        Entity entityToDrop = world.createEntity(EntityTypes.ITEM, position);
        entityToDrop.offer(Keys.REPRESENTED_ITEM, (Object)itemStackSnapshotToDrop);
        world.spawnEntity(entityToDrop);
        return itemStackSnapshotToDrop.createStack();
    }

    public static Inventory getStandardInventory(Carrier player) {
        return player.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(MainPlayerInventory.class)}).transform(InventoryTransformations.PLAYER_MAIN_HOTBAR_FIRST);
    }

    public static <T extends Event> void onPlayerSimulatedOrPlayer(T event, BiConsumer<T, Player> eventConsumer) {
        Player cs = Util.checkSimulated(event).orElseGet(() -> {
            Object root = event.getCause().root();
            if (root instanceof Player) {
                return (Player)root;
            }
            return null;
        });
        if (cs != null) {
            eventConsumer.accept(event, cs);
        }
    }

    public static <T extends Event> void onSourceSimulatedOr(T event, Function<T, Optional<CommandSource>> orElse, BiConsumer<T, CommandSource> eventConsumer) {
        CommandSource cs = Util.checkSimulated(event).map(x -> x).orElseGet(() -> ((Optional)orElse.apply(event)).orElse(null));
        if (cs != null) {
            eventConsumer.accept(event, cs);
        }
    }

    private static Optional<Player> checkSimulated(Event event) {
        return event.getContext().get(EventContextKeys.PLAYER_SIMULATED).map(x -> Sponge.getServer().getPlayer(x.getUniqueId()).orElse(null));
    }

    public static boolean hasPlayedBeforeSponge(User player) {
        Instant instant = player.get(Keys.FIRST_DATE_PLAYED).orElseGet(Instant::now);
        Instant next = Instant.now().plus(10L, ChronoUnit.SECONDS);
        return instant.isAfter(next);
    }
}

