/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.api.module.kit;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.Text;

public interface KitRedeemResult {
    default public boolean isSuccess() {
        return this.getStatus() == Status.SUCCESS || this.getStatus() == Status.PARTIAL_SUCCESS;
    }

    public Status getStatus();

    public Optional<Instant> getCooldownExpiry();

    default public Optional<Duration> getCooldownDuration() {
        return this.getCooldownExpiry().map(x -> {
            Instant now = Instant.now();
            if (x.isAfter(now)) {
                return Duration.between(now, x);
            }
            return null;
        });
    }

    public Optional<Text> getMessage();

    public Collection<ItemStackSnapshot> rejectedItems();

    public static enum Status {
        SUCCESS,
        PARTIAL_SUCCESS,
        ALREADY_REDEEMED_ONE_TIME,
        COOLDOWN_NOT_EXPIRED,
        NO_SPACE,
        PRE_EVENT_CANCELLED,
        UNKNOWN;

    }
}

