/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.afk.commands;

import io.github.nucleuspowered.nucleus.modules.afk.services.AFKHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.util.TypeTokens;
import java.util.Collection;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.FormattingCodeTextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;

@Command(aliases={"afkkick", "kickafk"}, basePermission={"nucleus.afkkick.base"}, commandDescriptionKey="afkkick")
public class AFKKickCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.OPTIONAL_REASON};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Optional<Text> reason = context.getOne("reason", TypeTokens.STRING).map(arg_0 -> ((FormattingCodeTextSerializer)TextSerializers.FORMATTING_CODE).deserialize(arg_0));
        Collection<Player> playersToKick = context.getServiceCollection().getServiceUnchecked(AFKHandler.class).getAfk(x -> !context.testPermissionFor((Subject)x, "nucleus.afk.exempt.kick"));
        if (playersToKick.isEmpty()) {
            return context.errorResult("command.afkkick.nokick", new Object[0]);
        }
        IMessageProviderService messageProviderService = context.getServiceCollection().messageProvider();
        int number = playersToKick.size();
        playersToKick.forEach(x -> x.kick(reason.orElseGet(() -> messageProviderService.getMessageFor(x.getLocale(), "afk.kickreason"))));
        context.sendMessage("command.afkkick.success", number);
        return context.successResult();
    }
}

