/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.ban.commands;

import io.github.nucleuspowered.nucleus.configurate.config.CommonPermissionLevelConfig;
import io.github.nucleuspowered.nucleus.modules.ban.config.BanConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.ban.Ban;
import org.spongepowered.api.util.ban.BanTypes;

@Command(aliases={"ban"}, basePermission={"nucleus.ban.base"}, commandDescriptionKey="ban", associatedPermissions={"nucleus.ban.offline", "nucleus.ban.exempt.target", "nucleus.ban.notify"}, associatedPermissionLevelKeys={"nucleus.ban.level"})
@EssentialsEquivalent(value={"ban"})
@NonnullByDefault
public class BanCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private CommonPermissionLevelConfig levelConfig = new CommonPermissionLevelConfig();
    private final String name = "name";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.firstParsing((CommandElement[])new CommandElement[]{NucleusParameters.ONE_GAME_PROFILE_UUID.get(serviceCollection), NucleusParameters.ONE_GAME_PROFILE.get(serviceCollection), GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)this.name)))}), GenericArguments.optionalWeak((CommandElement)NucleusParameters.REASON)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        String r = context.getOne("reason", String.class).orElseGet(() -> context.getMessageString("ban.defaultreason", new Object[0]));
        Optional<GameProfile> ou = context.getOne("user uuid", GameProfile.class);
        if (!ou.isPresent()) {
            ou = context.getOne("user", GameProfile.class);
        }
        if (ou.isPresent()) {
            Optional optionalUser = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(ou.get());
            if (!(optionalUser.isPresent() && ((User)optionalUser.get()).isOnline() || context.testPermission("nucleus.ban.offline"))) {
                return context.errorResult("command.ban.offline.noperms", new Object[0]);
            }
            if (optionalUser.isPresent() && !context.isConsoleAndBypass() && context.testPermissionFor((Subject)optionalUser.get(), "nucleus.ban.exempt.target")) {
                return context.errorResult("command.ban.exempt", ((User)optionalUser.get()).getName());
            }
            return this.executeBan(context, ou.get(), r);
        }
        if (!context.testPermission("nucleus.ban.offline")) {
            return context.errorResult("command.ban.offline.noperms", new Object[0]);
        }
        String userToFind = context.requireOne(this.name, String.class);
        Sponge.getScheduler().createAsyncExecutor((Object)context.getServiceCollection().pluginContainer()).execute(() -> {
            GameProfileManager gpm = Sponge.getServer().getGameProfileManager();
            try {
                GameProfile gp = (GameProfile)gpm.get(userToFind).get();
                Sponge.getScheduler().createSyncExecutor((Object)context.getServiceCollection().pluginContainer()).execute(() -> {
                    UserStorageService uss = (UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class);
                    User user = uss.getOrCreate(gp);
                    context.sendMessage("gameprofile.new", user.getName());
                    try {
                        this.executeBan(context, gp, r);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                context.sendMessage("command.ban.profileerror", userToFind);
            }
        });
        return context.successResult();
    }

    private ICommandResult executeBan(ICommandContext<? extends CommandSource> context, GameProfile u, String r) {
        BanService service = (BanService)Sponge.getServiceManager().provideUnchecked(BanService.class);
        CommandSource src = context.getCommandSourceUnchecked();
        UserStorageService uss = (UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class);
        User user = (User)uss.get(u).get();
        if (!user.isOnline() && !context.testPermission("nucleus.ban.offline")) {
            return context.errorResult("command.ban.offline.noperms", new Object[0]);
        }
        if (service.isBanned(u)) {
            return context.errorResult("command.ban.alreadyset", u.getName().orElse(context.getServiceCollection().messageProvider().getMessageString(src, "standard.unknown", new String[0])));
        }
        if (this.levelConfig.isUseLevels() && !context.isPermissionLevelOkay((Subject)user, "nucleus.ban.level", "nucleus.ban.base", this.levelConfig.isCanAffectSameLevel())) {
            return context.errorResult("command.modifiers.level.insufficient", u.getName().orElse(context.getServiceCollection().messageProvider().getMessageString(src, "standard.unknown", new String[0])));
        }
        Ban bp = Ban.builder().type(BanTypes.PROFILE).profile(u).source(src).reason(TextSerializers.FORMATTING_CODE.deserialize(r)).build();
        service.addBan(bp);
        MutableMessageChannel send = context.getServiceCollection().permissionService().permissionMessageChannel("nucleus.ban.notify").asMutable();
        send.addMember((MessageReceiver)src);
        send.send(context.getMessage("command.ban.applied", u.getName().orElseGet(() -> context.getMessageString("standard.unknown", new Object[0])), src.getName()));
        send.send(context.getMessage("standard.reasoncoloured", r));
        if (Sponge.getServer().getPlayer(u.getUniqueId()).isPresent()) {
            ((Player)Sponge.getServer().getPlayer(u.getUniqueId()).get()).kick(TextSerializers.FORMATTING_CODE.deserialize(r));
        }
        return context.successResult();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.levelConfig = serviceCollection.moduleDataProvider().getModuleConfig(BanConfig.class).getLevelConfig();
    }
}

