/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.chat.listeners;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.chat.config.ChatConfig;
import io.github.nucleuspowered.nucleus.modules.chat.config.ChatTemplateConfig;
import io.github.nucleuspowered.nucleus.modules.chat.services.ChatService;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IChatMessageFormatterService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.ITextStyleService;
import javax.inject.Inject;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.text.transform.SimpleTextFormatter;
import org.spongepowered.api.text.transform.SimpleTextTemplateApplier;

public class ChatListener
implements IReloadableService.Reloadable,
ListenerBase.Conditional {
    private final ChatService chatService;
    private final ITextStyleService textStyleService;
    private final IPermissionService permissionService;
    private final IChatMessageFormatterService chatMessageFormatterService;
    private ChatConfig chatConfig;

    @Inject
    public ChatListener(INucleusServiceCollection serviceCollection) {
        this.chatService = serviceCollection.getServiceUnchecked(ChatService.class);
        this.textStyleService = serviceCollection.textStyleService();
        this.chatConfig = serviceCollection.moduleDataProvider().getModuleConfig(ChatConfig.class);
        this.permissionService = serviceCollection.permissionService();
        this.chatMessageFormatterService = serviceCollection.chatMessageFormatter();
    }

    @Listener(order=Order.EARLY, beforeModifications=true)
    public void onPlayerChat(MessageChannelEvent.Chat event) {
        Util.onPlayerSimulatedOrPlayer(event, this::onPlayerChatInternal);
    }

    private void onPlayerChatInternal(MessageChannelEvent.Chat event, Player player) {
        ChatTemplateConfig ctc;
        if (this.chatMessageFormatterService.getNucleusChannel(player.getUniqueId()).map(IChatMessageFormatterService.Channel::willFormat).orElse(false).booleanValue()) {
            return;
        }
        MessageEvent.MessageFormatter eventFormatter = event.getFormatter();
        Text rawMessage = eventFormatter.getBody().isEmpty() ? event.getRawMessage() : eventFormatter.getBody().toText();
        SimpleTextFormatter headerFormatter = eventFormatter.getHeader();
        SimpleTextFormatter footerFormatter = eventFormatter.getFooter();
        if (this.chatConfig.isOverwriteEarlyPrefixes()) {
            eventFormatter.setHeader((TextRepresentable)Text.EMPTY);
            headerFormatter.clear();
        } else if (this.chatConfig.isTryRemoveMinecraftPrefix()) {
            for (SimpleTextTemplateApplier stta : eventFormatter.getHeader()) {
                if (!(stta instanceof MessageEvent.DefaultHeaderApplier)) continue;
                eventFormatter.getHeader().remove(stta);
            }
        }
        if (this.chatConfig.isOverwriteEarlySuffixes()) {
            footerFormatter.clear();
        }
        if (!(ctc = this.chatConfig.isUseGroupTemplates() ? this.chatService.getTemplateNow((Subject)player) : this.chatConfig.getDefaultTemplate()).getPrefix().isEmpty()) {
            SimpleTextTemplateApplier headerApplier = new SimpleTextTemplateApplier();
            headerApplier.setTemplate(TextTemplate.of((Object[])new Object[]{ctc.getPrefix().getForCommandSource((CommandSource)player)}));
            event.getFormatter().getHeader().add(headerApplier);
        }
        if (!ctc.getSuffix().isEmpty()) {
            SimpleTextTemplateApplier footerApplier = new SimpleTextTemplateApplier();
            footerApplier.setTemplate(TextTemplate.of((Object[])new Object[]{ctc.getSuffix().getForCommandSource((CommandSource)player)}));
            event.getFormatter().getFooter().add(footerApplier);
        }
        event.getFormatter().setBody((TextRepresentable)(this.chatConfig.isModifyMainMessage() ? this.useMessage(player, rawMessage, ctc) : rawMessage));
    }

    @Override
    public boolean shouldEnable(INucleusServiceCollection serviceCollection) {
        return serviceCollection.moduleDataProvider().getModuleConfig(ChatConfig.class).isModifychat();
    }

    private Text useMessage(Player player, Text rawMessage, ChatTemplateConfig chatTemplateConfig) {
        String m = TextSerializers.FORMATTING_CODE.serialize(rawMessage);
        if (this.chatConfig.isRemoveBlueUnderline()) {
            m = m.replaceAll("&9&n([A-Za-z0-9-.]+)(&r)?", "$1");
        }
        m = this.textStyleService.stripPermissionless("nucleus.chat.color", "nucleus.chat.style", (Subject)player, m);
        Text result = this.permissionService.hasPermission((Subject)player, "nucleus.chat.url") ? this.textStyleService.addUrls(m, !this.chatConfig.isRemoveBlueUnderline()) : TextSerializers.FORMATTING_CODE.deserialize(m);
        String chatcol = this.permissionService.getOptionFromSubject((Subject)player, "chatcolour", "chatcolor").orElseGet(chatTemplateConfig::getChatcolour);
        String chatstyle = this.permissionService.getOptionFromSubject((Subject)player, "chatstyle").orElseGet(chatTemplateConfig::getChatstyle);
        return Text.of((Object[])new Object[]{this.textStyleService.getColourFromString(chatcol), this.textStyleService.getTextStyleFromString(chatstyle), result});
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.chatConfig = serviceCollection.moduleDataProvider().getModuleConfig(ChatConfig.class);
    }
}

