/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands;

import com.google.inject.Inject;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.core.NucleusUserPreferenceService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.userprefs.PreferenceKeyImpl;
import io.github.nucleuspowered.nucleus.services.impl.userprefs.UserPreferenceService;
import io.github.nucleuspowered.nucleus.services.interfaces.IUserPreferenceService;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Command(aliases={"nuserprefs", "userprefs"}, basePermission={"nucleus.userprefs.base"}, commandDescriptionKey="nuserprefs", prefixAliasesWithN=false, async=true, associatedPermissions={"nucleus.userprefs.others"})
@NonnullByDefault
public class NucleusUserPrefsCommand
implements ICommandExecutor<CommandSource> {
    private static final Text SEPARATOR = Text.of((String)": ");
    private final IUserPreferenceService userPreferenceService;

    @Inject
    public NucleusUserPrefsCommand(INucleusServiceCollection serviceCollection) {
        this.userPreferenceService = serviceCollection.userPreferenceService();
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOtherUserPermissionElement(false, "nucleus.userprefs.others"), GenericArguments.optional((CommandElement)this.userPreferenceService.getElement())};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User target = context.getUserFromArgs();
        if (context.hasAny(UserPreferenceService.PREFERENCE_ARG.toPlain())) {
            if (context.hasAny(UserPreferenceService.VALUE_ARG.toPlain())) {
                return this.set(context, target, context.is(target), context.requireOne(UserPreferenceService.PREFERENCE_ARG.toPlain(), PreferenceKeyImpl.class), context.requireOne(UserPreferenceService.VALUE_ARG.toPlain(), Object.class));
            }
            return this.get(context, target, context.requireOne(UserPreferenceService.PREFERENCE_ARG.toPlain(), PreferenceKeyImpl.class));
        }
        return this.list(context, target);
    }

    private <T> ICommandResult set(ICommandContext<? extends CommandSource> context, User target, boolean isSelf, PreferenceKeyImpl<T> key, @Nullable Object value) {
        this.userPreferenceService.set(target.getUniqueId(), key, key.getValueClass().cast(value));
        if (isSelf) {
            context.sendMessage("command.userprefs.set.self", key.getID(), value);
        } else {
            context.sendMessage("command.userprefs.set.other", target, key.getID(), value);
        }
        return context.successResult();
    }

    private <T> ICommandResult get(ICommandContext<? extends CommandSource> context, User target, PreferenceKeyImpl<T> key) throws CommandException {
        context.sendMessageText(this.get(context, context.getServiceCollection().userPreferenceService(), key, this.userPreferenceService.get(target.getUniqueId(), key).orElse(null)));
        return context.successResult();
    }

    private ICommandResult list(ICommandContext<? extends CommandSource> context, User target) throws CommandException {
        Map<NucleusUserPreferenceService.PreferenceKey<?>, Object> ret = this.userPreferenceService.get(target);
        ArrayList<Text> entry = new ArrayList<Text>();
        for (Map.Entry<NucleusUserPreferenceService.PreferenceKey<?>, Object> e : ret.entrySet()) {
            NucleusUserPreferenceService.PreferenceKey<?> key = e.getKey();
            Object value = e.getValue();
            entry.add(this.get(context, this.userPreferenceService, key, value));
        }
        Util.getPaginationBuilder(context.getCommandSource()).title(context.getServiceCollection().messageProvider().getMessageFor(context.getCommandSource(), "command.userprefs.title", target.getName())).contents(entry).build().sendTo((MessageReceiver)context.getCommandSource());
        return context.successResult();
    }

    private Text get(ICommandContext<? extends CommandSource> context, IUserPreferenceService userPreferenceService, NucleusUserPreferenceService.PreferenceKey<?> key, @Nullable Object value) throws CommandException {
        LiteralText.Builder tb = Text.builder((String)key.getID().replaceAll("^nucleus:", ""));
        tb.append(new Text[]{SEPARATOR});
        CommandSource commandSource = context.getCommandSource();
        Text result = value == null ? context.getServiceCollection().messageProvider().getMessageFor(commandSource, "standard.unset") : (value instanceof Boolean ? context.getServiceCollection().messageProvider().getMessageFor(commandSource, "standard." + (Boolean)value) : Text.of((Object[])new Object[]{value}));
        tb.append(new Text[]{result});
        String desc = userPreferenceService.getDescription(key);
        if (desc != null && !desc.isEmpty()) {
            tb.onHover((HoverAction)TextActions.showText((Text)(key instanceof PreferenceKeyImpl ? context.getServiceCollection().messageProvider().getMessageFor(commandSource, ((PreferenceKeyImpl)key).getDescriptionKey()) : Text.of((String)desc))));
        }
        return tb.build();
    }
}

