/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.github.nucleuspowered.nucleus.modules.core.commands.NucleusCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.data.SuggestedLevel;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"setupperms", "setperms"}, basePermission={"nucleus.nucleus.setupperms.base"}, commandDescriptionKey="nucleus.setupperms", parentCommand=NucleusCommand.class)
public class SetupPermissionsCommand
implements ICommandExecutor<CommandSource> {
    private final String roleKey = "Nucleus Role";
    private final String groupKey = "Permission Group";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.flags().flag(new String[]{"r", "-reset"}).flag(new String[]{"i", "-inherit"}).buildWith(GenericArguments.seq((CommandElement[])new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.enumValue((Text)Text.of((String)this.roleKey), SuggestedLevel.class)), GenericArguments.onlyOne((CommandElement)new GroupArgument((Text)Text.of((String)this.groupKey), serviceCollection.messageProvider()))}))})};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        SuggestedLevel sl = context.requireOne(this.roleKey, SuggestedLevel.class);
        Subject group = context.requireOne(this.groupKey, Subject.class);
        boolean reset = context.hasAny("r");
        boolean inherit = context.hasAny("i");
        return this.setupPerms(context, group, sl, reset, inherit);
    }

    private ICommandResult setupPerms(ICommandContext<? extends CommandSource> src, Subject group, SuggestedLevel level, boolean reset, boolean inherit) {
        PermissionService ps = (PermissionService)Sponge.getServiceManager().provideUnchecked(PermissionService.class);
        if (ps.getClass().getPackage().getName().startsWith("org.spongepowered.common")) {
            return src.errorResult("command.nucleus.permission.noperms", new Object[0]);
        }
        if (inherit && level.getLowerLevel() != null) {
            this.setupPerms(src, group, level.getLowerLevel(), reset, inherit);
        }
        HashSet globalContext = Sets.newHashSet();
        SubjectData data = group.getSubjectData();
        Set definedPermissions = data.getPermissions((Set)ImmutableSet.of()).keySet();
        Logger logger = src.getServiceCollection().logger();
        IMessageProviderService messageProvider = src.getServiceCollection().messageProvider();
        IPermissionService permissionService = src.getServiceCollection().permissionService();
        permissionService.getAllMetadata().stream().filter(x -> x.getSuggestedLevel() == level).filter(x -> reset || !definedPermissions.contains(x.getPermission())).forEach(x -> {
            logger.info(messageProvider.getMessageString("command.nucleus.permission.added", x.getPermission(), group.getIdentifier()));
            data.setPermission(globalContext, x.getPermission(), Tristate.TRUE);
        });
        src.sendMessage("command.nucleus.permission.complete", level.toString().toLowerCase(), group.getIdentifier());
        return src.successResult();
    }

    private static class GroupArgument
    extends CommandElement {
        private final IMessageProviderService messageProviderService;

        GroupArgument(@Nullable Text key, IMessageProviderService messageProviderService) {
            super(key);
            this.messageProviderService = messageProviderService;
        }

        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String a = args.next();
            Optional<String> ls = this.getGroups(source, args).stream().filter(x -> x.equalsIgnoreCase(a)).findFirst();
            if (ls.isPresent()) {
                return ((PermissionService)Sponge.getServiceManager().provide(PermissionService.class).get()).getGroupSubjects().getSubject(ls.get()).get();
            }
            throw args.createError(this.messageProviderService.getMessageFor(source, "args.permissiongroup.nogroup", a));
        }

        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            try {
                String a = args.peek();
                return this.getGroups(src, args).stream().filter(x -> x.toLowerCase().contains(a)).collect(Collectors.toList());
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }

        private Set<String> getGroups(CommandSource source, CommandArgs args) throws ArgumentParseException {
            Optional ops = Sponge.getServiceManager().provide(PermissionService.class);
            if (!ops.isPresent()) {
                throw args.createError(this.messageProviderService.getMessageFor(source, "args.permissiongroup.noservice"));
            }
            PermissionService ps = (PermissionService)ops.get();
            if (ps.getClass().getPackage().getName().startsWith("org.spongepowered.common")) {
                throw args.createError(this.messageProviderService.getMessageFor(source, "command.nucleus.permission.noperms"));
            }
            try {
                return Sets.newHashSet((Iterable)((Iterable)ps.getGroupSubjects().getAllIdentifiers().get()));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw args.createError(this.messageProviderService.getMessageFor(source, "args.permissiongroup.failed"));
            }
        }
    }
}

