/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.services;

import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.scaffold.service.ServiceBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IUserDataObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.queryobjects.IUserQueryObject;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.storage.services.IStorageService;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.manipulator.mutable.entity.JoinData;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.user.UserStorageService;

@Singleton
public class UniqueUserService
implements ServiceBase,
IReloadableService.Reloadable {
    public static UniqueUserService INSTANCE;
    private final INucleusServiceCollection serviceCollection;
    private boolean isMoreAccurate = false;
    private static boolean ERROR_REPORTED;
    private long userCount = 0L;
    private boolean userCountIsDirty = false;

    @Inject
    public UniqueUserService(INucleusServiceCollection serviceCollection) {
        if (INSTANCE == null) {
            INSTANCE = this;
        }
        this.serviceCollection = serviceCollection;
    }

    public long getUniqueUserCount() {
        if (this.userCountIsDirty) {
            return this.userCount + 1L;
        }
        return this.userCount;
    }

    public void resetUniqueUserCount() {
        this.resetUniqueUserCount(null);
    }

    public void resetUniqueUserCount(@Nullable Consumer<Long> resultConsumer) {
        if (!this.userCountIsDirty) {
            this.userCountIsDirty = true;
            ERROR_REPORTED = false;
            if (Sponge.getServer().isMainThread()) {
                Task.builder().async().execute(t -> this.doTask(resultConsumer)).submit((Object)this.serviceCollection.pluginContainer());
            } else {
                this.doTask(resultConsumer);
            }
        }
    }

    private void doTask(@Nullable Consumer<Long> resultConsumer) {
        UserStorageService uss = (UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class);
        IStorageService.Keyed.KeyedData<UUID, IUserQueryObject, IUserDataObject> service = this.serviceCollection.storageManager().getUserService();
        this.userCount = this.isMoreAccurate ? uss.getAll().stream().filter(GameProfile::isFilled).map(arg_0 -> ((UserStorageService)uss).get(arg_0)).filter(Optional::isPresent).filter(x -> {
            boolean ret;
            block5: {
                boolean bl = ret = ((User)x.get()).getPlayer().isPresent() || service.exists((IUserQueryObject)((Object)((User)x.get()).getUniqueId())).join() != false;
                if (!ret) {
                    try {
                        return ((User)x.get()).get(JoinData.class).map(y -> y.firstPlayed().getDirect().isPresent()).orElse(false);
                    }
                    catch (IllegalStateException e) {
                        if (!ERROR_REPORTED) {
                            ERROR_REPORTED = true;
                            this.serviceCollection.logger().warn("The Sponge player data provider has not yet been initialised, not using join data in this count.");
                        }
                    }
                    catch (NoSuchElementException e) {
                        if (ERROR_REPORTED) break block5;
                        ERROR_REPORTED = true;
                        this.serviceCollection.logger().warn("The join data can not be constructed on some users.");
                    }
                }
            }
            return ret;
        }).count() : uss.getAll().stream().filter(GameProfile::isFilled).filter(x -> service.exists((IUserQueryObject)((Object)x.getUniqueId())).join()).count();
        this.userCountIsDirty = false;
        if (resultConsumer != null) {
            resultConsumer.accept(this.userCount);
        }
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.isMoreAccurate = serviceCollection.moduleDataProvider().getModuleConfig(CoreConfig.class).isMoreAccurate();
    }

    static {
        ERROR_REPORTED = false;
    }
}

