/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.teleport.scanners;

import com.flowpowered.math.vector.Vector3i;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanner;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;
import org.spongepowered.plugin.meta.util.NonnullByDefault;

public abstract class VerticalTeleportScanner
implements TeleportScanner {
    @Override
    public Optional<Location<World>> scanFrom(World world, Vector3i position, int width, int height, int floorDistance, TeleportHelperFilter filter, TeleportHelperFilter ... filters) {
        int maxy = world.getBlockMax().getY();
        int jumps = height * 2 - 1;
        do {
            Optional result;
            if (!(result = Sponge.getTeleportHelper().getSafeLocation(new Location((Extent)world, position), height, width, floorDistance, filter, filters)).isPresent()) continue;
            return result;
        } while ((position = position.add(0, jumps, 0)).getY() < maxy);
        return Optional.empty();
    }

    @NonnullByDefault
    public static class Descending
    extends VerticalTeleportScanner {
        public String getId() {
            return "nucleus:descending_scan";
        }

        public String getName() {
            return "Nucleus Descending Scan";
        }
    }

    @NonnullByDefault
    public static class Ascending
    extends VerticalTeleportScanner {
        public String getId() {
            return "nucleus:ascending_scan";
        }

        public String getName() {
            return "Nucleus Ascending Scan";
        }
    }
}

