/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.fun.commands;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@EssentialsEquivalent(value={"burn"})
@NonnullByDefault
@Command(aliases={"ignite", "burn"}, basePermission={"nucleus.ignite.base"}, commandDescriptionKey="ignite", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.ignite.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.ignite.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.ignite.exempt.cost")}, associatedPermissions={"nucleus.ignite.others"})
public class IgniteCommand
implements ICommandExecutor<CommandSource> {
    private final String ticks = "ticks";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOtherUserPermissionElement(true, "nucleus.ignite.others"), GenericArguments.onlyOne((CommandElement)GenericArguments.integer((Text)Text.of((String)this.ticks)))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Player target = context.getPlayerFromArgs();
        int ticksInput = context.requireOne(this.ticks, Integer.class);
        GameMode gm = target.get(Keys.GAME_MODE).orElse(GameModes.SURVIVAL);
        if (gm == GameModes.CREATIVE || gm == GameModes.SPECTATOR) {
            return context.errorResult("command.ignite.gamemode", target.getName());
        }
        if (target.offer(Keys.FIRE_TICKS, (Object)ticksInput).isSuccessful()) {
            context.sendMessage("command.ignite.success", target.getName(), String.valueOf(ticksInput));
            return context.successResult();
        }
        return context.errorResult("command.ignite.error", target.getName());
    }
}

