/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.home.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.home.data.Home;
import io.github.nucleuspowered.nucleus.api.util.data.NamedLocation;
import io.github.nucleuspowered.nucleus.modules.home.commands.HomeCommand;
import io.github.nucleuspowered.nucleus.modules.home.config.HomeConfig;
import io.github.nucleuspowered.nucleus.modules.home.services.HomeService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@NonnullByDefault
@Command(aliases={"list", "#listhomes", "#homes"}, basePermission={"nucleus.home.list.base"}, commandDescriptionKey="home.list", parentCommand=HomeCommand.class, async=true, associatedPermissions={"nucleus.home.list.others"})
public class ListHomeCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private boolean isOnlySameDimension = false;

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOnlyOtherUserPermissionElement(false, "nucleus.home.list.others")};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        boolean other;
        User user = context.getUserFromArgs();
        boolean bl = other = !context.is(user);
        if (other && (context.isConsoleAndBypass() || context.testPermissionFor((Subject)user, "nucleus.home.other.exempt.target"))) {
            return context.errorResult("command.listhome.exempt", new Object[0]);
        }
        List<Home> msw = context.getServiceCollection().getServiceUnchecked(HomeService.class).getHomes(user);
        if (msw.isEmpty()) {
            return context.errorResult("command.home.nohomes", new Object[0]);
        }
        CommandSource source = context.getCommandSource();
        IMessageProviderService messageProviderService = context.getServiceCollection().messageProvider();
        Text header = other ? messageProviderService.getMessageFor(source, "home.title.name", user.getName()) : messageProviderService.getMessageFor(source, "home.title.normal");
        IPermissionService permissionService = context.getServiceCollection().permissionService();
        List lt = msw.stream().sorted(Comparator.comparing(NamedLocation::getName)).map(x -> {
            Optional<Location<World>> olw = x.getLocation();
            if (!olw.isPresent()) {
                return Text.builder().append(new Text[]{Text.builder((String)x.getName()).color(TextColors.RED).onHover((HoverAction)TextActions.showText((Text)messageProviderService.getMessageFor(source, "home.warphoverinvalid", x.getName()))).build()}).build();
            }
            Location<World> lw = olw.get();
            Text textMessage = messageProviderService.getMessageFor(source, "home.location", ((World)lw.getExtent()).getName(), lw.getBlockX(), lw.getBlockY(), lw.getBlockZ());
            if (this.isOnlySameDimension && source instanceof Player && !other && !((World)lw.getExtent()).getUniqueId().equals(((World)((Player)source).getLocation().getExtent()).getUniqueId()) && !context.isConsoleAndBypass() && !permissionService.hasPermission((Subject)user, "nucleus.home.exempt.samedimension")) {
                return Text.builder().append(new Text[]{Text.builder((String)x.getName()).color(TextColors.LIGHT_PURPLE).onHover((HoverAction)TextActions.showText((Text)messageProviderService.getMessageFor(source, "home.warphoverotherdimension", x.getName()))).build()}).append(new Text[]{textMessage}).build();
            }
            return Text.builder().append(new Text[]{Text.builder((String)x.getName()).color(TextColors.GREEN).style(new TextStyle[]{TextStyles.UNDERLINE}).onHover((HoverAction)TextActions.showText((Text)messageProviderService.getMessageFor(source, "home.warphover", x.getName()))).onClick((ClickAction)TextActions.runCommand((String)(other ? "/homeother " + user.getName() + " " + x.getName() : "/home " + x.getName()))).build()}).append(new Text[]{textMessage}).build();
        }).collect(Collectors.toList());
        PaginationList.Builder pb = Util.getPaginationBuilder(source).title(Text.of((Object[])new Object[]{TextColors.YELLOW, header})).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).contents(lt);
        pb.sendTo((MessageReceiver)source);
        return context.successResult();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        HomeConfig hc = serviceCollection.moduleDataProvider().getModuleConfig(HomeConfig.class);
        this.isOnlySameDimension = hc.isOnlySameDimension();
    }
}

