/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.home.listeners;

import io.github.nucleuspowered.nucleus.api.EventContexts;
import io.github.nucleuspowered.nucleus.api.module.home.data.Home;
import io.github.nucleuspowered.nucleus.api.module.spawn.event.NucleusSendToSpawnEvent;
import io.github.nucleuspowered.nucleus.api.util.data.NamedLocation;
import io.github.nucleuspowered.nucleus.modules.home.config.HomeConfig;
import io.github.nucleuspowered.nucleus.modules.home.services.HomeService;
import io.github.nucleuspowered.nucleus.modules.spawn.events.SendToSpawnEvent;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import java.util.Optional;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.world.World;

public class RespawnConditionalListener
implements ListenerBase.Conditional {
    private final HomeService homeService;
    private final IMessageProviderService messageProviderService;

    @Inject
    public RespawnConditionalListener(INucleusServiceCollection serviceCollection) {
        this.homeService = serviceCollection.getServiceUnchecked(HomeService.class);
        this.messageProviderService = serviceCollection.messageProvider();
    }

    @Listener
    public void onRespawn(RespawnPlayerEvent event, @Getter(value="getTargetEntity") Player player) {
        Optional<Home> oh = this.homeService.getHome(player.getUniqueId(), "home");
        Optional ot = oh.flatMap(NamedLocation::getTransform);
        if (ot.isPresent()) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause((Object)event.getTargetEntity());
                frame.addContext(EventContexts.SPAWN_EVENT_TYPE, (Object)NucleusSendToSpawnEvent.Type.HOME_ON_DEATH);
                SendToSpawnEvent sEvent = new SendToSpawnEvent((Transform<World>)((Transform)ot.get()), (User)event.getTargetEntity(), frame.getCurrentCause());
                if (Sponge.getEventManager().post((Event)sEvent)) {
                    this.messageProviderService.sendMessageTo((CommandSource)event.getTargetEntity(), "command.home.fail", oh.get().getName());
                    return;
                }
                event.setToTransform(sEvent.getTransformTo());
            }
        }
    }

    @Override
    public boolean shouldEnable(INucleusServiceCollection serviceCollection) {
        return serviceCollection.moduleDataProvider().getModuleConfig(HomeConfig.class).isRespawnAtHome();
    }
}

