/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.inventory.listeners;

import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import javax.inject.Inject;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.service.permission.Subject;

public class KeepInventoryListener
implements ListenerBase.Conditional {
    private final IPermissionService permissionService;

    @Inject
    public KeepInventoryListener(INucleusServiceCollection serviceCollection) {
        this.permissionService = serviceCollection.permissionService();
    }

    @Listener
    public void onEntityDeath(DestructEntityEvent.Death event, @Getter(value="getTargetEntity") Player living) {
        if (this.permissionService.hasPermission((Subject)living, "nucleus.inventory.keepondeath")) {
            event.setKeepInventory(true);
        }
    }

    @Override
    public boolean shouldEnable(INucleusServiceCollection serviceCollection) {
        return !serviceCollection.permissionService().isOpOnly();
    }
}

