/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jail.infoprovider;

import io.github.nucleuspowered.nucleus.modules.jail.data.JailData;
import io.github.nucleuspowered.nucleus.modules.jail.services.JailHandler;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.playerinformation.NucleusProvider;
import java.util.Optional;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;

public class JailInfoProvider
implements NucleusProvider {
    @Override
    public String getCategory() {
        return "punishment";
    }

    @Override
    public Optional<Text> get(User user, CommandSource source, INucleusServiceCollection serviceCollection) {
        if (serviceCollection.permissionService().hasPermission((Subject)source, "nucleus.jail.checkjail.base")) {
            JailHandler jh = serviceCollection.getServiceUnchecked(JailHandler.class);
            if (jh.isPlayerJailed(user)) {
                JailData jd = jh.getPlayerJailDataInternal(user).get();
                Text.Builder m = jd.getRemainingTime().isPresent() ? serviceCollection.messageProvider().getMessageFor(source, "seen.isjailed.temp", serviceCollection.messageProvider().getTimeString(source.getLocale(), jd.getRemainingTime().get().getSeconds())).toBuilder() : serviceCollection.messageProvider().getMessageFor(source.getLocale(), "seen.isjailed.perm").toBuilder();
                return Optional.of(Text.of((Object[])new Object[]{m.onClick((ClickAction)TextActions.runCommand((String)("/nucleus:checkjail " + user.getName()))).onHover((HoverAction)TextActions.showText((Text)serviceCollection.messageProvider().getMessageFor(source.getLocale(), "standard.clicktoseemore"))).build(), Text.NEW_LINE, serviceCollection.messageProvider().getMessageFor(source.getLocale(), "standard.reason", jd.getReason())}));
            }
            return Optional.of(serviceCollection.messageProvider().getMessageFor(source.getLocale(), "seen.notjailed"));
        }
        return Optional.empty();
    }
}

