/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.parameters;

import com.google.common.collect.ImmutableList;
import io.github.nucleuspowered.nucleus.api.module.kit.data.Kit;
import io.github.nucleuspowered.nucleus.modules.kit.KitPermissions;
import io.github.nucleuspowered.nucleus.modules.kit.services.KitService;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;

public class KitParameter
extends CommandElement {
    public static final String KIT_PARAMETER_KEY = "kit";
    private final KitService kitService;
    private final IPermissionService permissionService;
    private final IMessageProviderService messageProviderService;
    private boolean permissionCheck;

    public KitParameter(KitService handler, IMessageProviderService messageProviderService, IPermissionService permissionService, boolean permissionCheck) {
        super((Text)Text.of((String)KIT_PARAMETER_KEY));
        this.kitService = handler;
        this.messageProviderService = messageProviderService;
        this.permissionCheck = permissionCheck;
        this.permissionService = permissionService;
    }

    @Nullable
    protected Object parseValue(@NonNull CommandSource source, CommandArgs args) throws ArgumentParseException {
        String kitName = args.next();
        if (kitName.isEmpty()) {
            throw args.createError(this.messageProviderService.getMessageFor(source, "args.kit.noname"));
        }
        Kit kit = this.kitService.getKit(kitName).orElseThrow(() -> args.createError(this.messageProviderService.getMessageFor(source, "args.kit.noexist")));
        if (!this.checkPermission(source, kit)) {
            throw args.createError(this.messageProviderService.getMessageFor(source, "args.kit.noperms"));
        }
        return kit;
    }

    public @NonNull List<String> complete(@NonNull CommandSource src, CommandArgs args, @NonNull CommandContext context) {
        try {
            boolean showhidden = this.permissionService.hasPermission((Subject)src, "nucleus.kit.showhidden");
            String name = args.peek().toLowerCase();
            return this.kitService.getKitNames().stream().filter(s -> s.toLowerCase().startsWith(name)).limit(20L).map(x -> this.kitService.getKit((String)x).get()).filter(x -> this.checkPermission(src, (Kit)x)).filter(x -> this.permissionCheck && (showhidden || !x.isHiddenFromList())).map(x -> x.getName().toLowerCase()).collect(Collectors.toList());
        }
        catch (ArgumentParseException e) {
            return ImmutableList.of();
        }
    }

    private boolean checkPermission(CommandSource src, Kit kit) {
        if (!this.permissionCheck) {
            return true;
        }
        return this.permissionService.hasPermission((Subject)src, KitPermissions.getKitPermission(kit.getName()));
    }
}

