/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.misc.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.ImprovedCatalogTypeArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.util.DataScanner;
import java.util.ArrayList;
import java.util.Optional;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@EssentialsEquivalent(value={"itemdb", "itemno", "durability", "dura"}, isExact=false, notes="Nucleus tries to provide much more info!")
@Command(aliases={"iteminfo", "itemdb"}, basePermission={"nucleus.iteminfo.base"}, commandDescriptionKey="iteminfo", associatedPermissions={"nucleus.iteminfo.extended"})
public class ItemInfoCommand
implements ICommandExecutor<CommandSource> {
    private final String key = "key";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().permissionFlag("nucleus.iteminfo.extended", new String[]{"e", "-extended"}).buildWith(GenericArguments.optional((CommandElement)new ImprovedCatalogTypeArgument((Text)Text.of((String)this.key), ItemType.class, serviceCollection)))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        ItemStack it;
        Optional<CatalogType> catalogTypeOptional = context.getOne(this.key, CatalogType.class);
        if (catalogTypeOptional.isPresent()) {
            CatalogType ct = catalogTypeOptional.get();
            if (ct instanceof ItemType) {
                it = ((ItemType)ct).getTemplate().createStack();
            } else {
                BlockState bs = (BlockState)ct;
                it = ((ItemType)bs.getType().getItem().orElseThrow(() -> context.createException("command.iteminfo.invalidblockstate", new Object[0]))).getTemplate().createStack();
                it.offer(Keys.ITEM_BLOCKSTATE, (Object)bs);
            }
        } else if (context.is(Player.class) && context.getIfPlayer().getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
            it = (ItemStack)context.getIfPlayer().getItemInHand(HandTypes.MAIN_HAND).get();
        } else {
            return context.errorResult("command.iteminfo.none", new Object[0]);
        }
        ArrayList<Text> lt = new ArrayList<Text>();
        lt.add(context.getMessage("command.iteminfo.id", it.getType().getId(), it.getTranslation().get()));
        Optional obs = it.get(Keys.ITEM_BLOCKSTATE);
        obs.ifPresent(blockState -> lt.add(context.getMessage("command.iteminfo.extendedid", blockState.getId())));
        if (context.hasAny("e") || context.hasAny("extended")) {
            DataScanner.getInstance(context.getServiceCollection().messageProvider()).getKeysForHolder((DataHolder)it).entrySet().stream().filter(x -> x.getValue() != null).filter(x -> {
                try {
                    return it.supports((Key)x.getValue());
                }
                catch (Exception e) {
                    return false;
                }
            }).forEach(x -> {
                Key k = (Key)x.getValue();
                if (it.get(k).isPresent()) {
                    DataScanner.getInstance(context.getServiceCollection().messageProvider()).getText((CommandSource)context.getCommandSourceUnchecked(), "command.iteminfo.key", (String)x.getKey(), it.get(k).get()).ifPresent(lt::add);
                }
            });
        }
        Util.getPaginationBuilder(context.getCommandSource()).contents(lt).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).title(context.getMessage("command.iteminfo.list.header", new Object[0])).sendTo((MessageReceiver)context.getCommandSource());
        return context.successResult();
    }
}

