/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.misc.commands;

import io.github.nucleuspowered.nucleus.modules.misc.config.MiscConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.HashMap;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@EssentialsEquivalent(value={"speed", "flyspeed", "walkspeed", "fspeed", "wspeed"}, isExact=false, notes="This command either uses your current state or a specified argument to determine whether to alter fly or walk speed.")
@Command(aliases={"speed"}, basePermission={"nucleus.speed.base"}, commandDescriptionKey="speed", modifiers={@CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.speed.exempt.warmup"), @CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.speed.exempt.cooldown"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.speed.exempt.cost")}, associatedPermissions={"nucleus.speed.exempt.max", "nucleus.speed.others"})
public class SpeedCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private final String speedKey = "speed";
    private final String resetKey = "reset";
    private final String typeKey = "type";
    public static final int multiplier = 20;
    private int maxSpeed = 5;

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        HashMap<String, SpeedType> keysMap = new HashMap<String, SpeedType>();
        keysMap.put("fly", SpeedType.FLYING);
        keysMap.put("flying", SpeedType.FLYING);
        keysMap.put("f", SpeedType.FLYING);
        keysMap.put("walk", SpeedType.WALKING);
        keysMap.put("w", SpeedType.WALKING);
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOtherUserPermissionElement(true, "nucleus.speed.others"), GenericArguments.optionalWeak((CommandElement)GenericArguments.onlyOne((CommandElement)GenericArguments.choices((Text)Text.of((String)this.typeKey), keysMap, (boolean)true))), GenericArguments.optional((CommandElement)GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.doubleNum((Text)Text.of((String)this.speedKey)), GenericArguments.literal((Text)Text.of((String)this.resetKey), (String[])new String[]{this.resetKey})}))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Player pl = context.getPlayerFromArgs();
        SpeedType key = context.getOne(this.typeKey, SpeedType.class).orElseGet(() -> pl.get(Keys.IS_FLYING).orElse(false) != false ? SpeedType.FLYING : SpeedType.WALKING);
        Double speed = context.getOne(this.speedKey, Double.class).orElseGet(() -> {
            if (context.hasAny(this.resetKey)) {
                return key == SpeedType.WALKING ? 2.0 : 1.0;
            }
            return null;
        });
        if (speed == null) {
            Text t = Text.builder().append(new Text[]{context.getMessage("command.speed.walk", new Object[0])}).append(new Text[]{Text.of((String)" ")}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, pl.get(Keys.WALKING_SPEED).orElse(0.1) * 20.0})}).append(new Text[]{Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, ", "})}).append(new Text[]{context.getMessage("command.speed.flying", new Object[0])}).build()}).append(new Text[]{Text.of((String)" ")}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, pl.get(Keys.FLYING_SPEED).orElse(0.05) * 20.0})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "."})}).build();
            context.sendMessageText(t);
            return context.failResult();
        }
        if (speed < 0.0) {
            return context.errorResult("command.speed.negative", new Object[0]);
        }
        if (!context.isConsoleAndBypass() && !context.testPermission("nucleus.speed.exempt.max") && (double)this.maxSpeed < speed) {
            return context.errorResult("command.speed.max", String.valueOf(this.maxSpeed));
        }
        DataTransactionResult dtr = pl.offer(key.speedKey, (Object)(speed / 20.0));
        if (dtr.isSuccessful()) {
            context.sendMessage("command.speed.success.base", key.name, String.valueOf(speed));
            if (!context.is(pl)) {
                context.sendMessage("command.speed.success.other", pl.getName(), key.name, String.valueOf(speed));
            }
            return context.successResult();
        }
        return context.errorResult("command.speed.fail", key.name);
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.maxSpeed = serviceCollection.moduleDataProvider().getModuleConfig(MiscConfig.class).getMaxSpeed();
    }

    private static enum SpeedType {
        WALKING((Key<Value<Double>>)Keys.WALKING_SPEED, "loc:standard.walking"),
        FLYING((Key<Value<Double>>)Keys.FLYING_SPEED, "loc:standard.flying");

        final Key<Value<Double>> speedKey;
        final String name;

        private SpeedType(Key<Value<Double>> speedKey, String name) {
            this.speedKey = speedKey;
            this.name = name;
        }
    }
}

