/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mute.runnables;

import io.github.nucleuspowered.nucleus.datatypes.EndTimestamp;
import io.github.nucleuspowered.nucleus.modules.mute.services.MuteHandler;
import io.github.nucleuspowered.nucleus.scaffold.task.TaskBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.scheduler.Task;

public class MuteTask
implements TaskBase {
    private final MuteHandler muteHandler;

    @Inject
    public MuteTask(INucleusServiceCollection serviceCollection) {
        this.muteHandler = serviceCollection.getServiceUnchecked(MuteHandler.class);
    }

    @Override
    public void accept(Task task) {
        Sponge.getServer().getOnlinePlayers().stream().filter(this.muteHandler::isMutedCached).filter(x -> this.muteHandler.getPlayerMuteData((User)x).map(EndTimestamp::expired).orElse(false)).forEach(this.muteHandler::unmutePlayer);
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public Duration interval() {
        return Duration.of(1L, ChronoUnit.SECONDS);
    }
}

