/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.powertool.listeners;

import io.github.nucleuspowered.nucleus.modules.powertool.services.PowertoolService;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.userprefs.NucleusKeysProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IUserPreferenceService;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.action.InteractEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.filter.type.Exclude;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.service.permission.Subject;

public class PowertoolListener
implements ListenerBase {
    private final PowertoolService service;
    private final IUserPreferenceService userPreferenceService;
    private final IPermissionService permissionService;
    private final IMessageProviderService messageProviderService;

    @Inject
    public PowertoolListener(INucleusServiceCollection serviceCollection) {
        this.service = serviceCollection.getServiceUnchecked(PowertoolService.class);
        this.userPreferenceService = serviceCollection.userPreferenceService();
        this.permissionService = serviceCollection.permissionService();
        this.messageProviderService = serviceCollection.messageProvider();
    }

    @Listener
    public void onLogout(ClientConnectionEvent.Disconnect event) {
        this.service.reset(event.getTargetEntity().getUniqueId());
    }

    @Listener
    @Exclude(value={InteractBlockEvent.class})
    public void onUserInteract(InteractEvent event, @Root Player player) {
        if (!this.permissionService.hasPermission((Subject)player, "nucleus.powertool.base") || !player.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
            return;
        }
        ItemType item = ((ItemStack)player.getItemInHand(HandTypes.MAIN_HAND).get()).getType();
        if (this.userPreferenceService.get(player.getUniqueId(), NucleusKeysProvider.POWERTOOL_ENABLED).orElse(true).booleanValue()) {
            this.service.getPowertoolForItem(player.getUniqueId(), item).ifPresent(x -> {
                event.setCancelled(true);
                Player interacting = event instanceof InteractEntityEvent && ((InteractEntityEvent)event).getTargetEntity() instanceof Player ? (Player)((InteractEntityEvent)event).getTargetEntity() : null;
                if (interacting == null && x.stream().allMatch(i -> i.contains("{{subject}}"))) {
                    this.messageProviderService.sendMessageTo((CommandSource)player, "powertool.playeronly");
                    return;
                }
                x.forEach(s -> {
                    if (s.contains("{{subject}}")) {
                        if (interacting != null) {
                            s = s.replace("{{subject}}", interacting.getName());
                        } else {
                            return;
                        }
                    }
                    Sponge.getCommandManager().process((CommandSource)player, s);
                });
            });
        }
    }
}

