/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.teleport.commands;

import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportResult;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanners;
import io.github.nucleuspowered.nucleus.modules.teleport.config.TeleportConfig;
import io.github.nucleuspowered.nucleus.modules.teleport.services.PlayerTeleporterService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.AlternativeUsageArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.DisplayNameArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.IfConditionElseArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.SelectorArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

@EssentialsEquivalent(value={"tp", "tele", "tp2p", "teleport", "tpo"}, isExact=false, notes="If you have permission, this will override '/tptoggle' automatically.")
@NonnullByDefault
@Command(aliases={"teleport", "tele", "$tp"}, basePermission={"nucleus.teleport.teleport.base"}, commandDescriptionKey="teleport", modifiers={@CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.teleport.teleport.exempt.warmup"), @CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.teleport.teleport.exempt.cooldown"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.teleport.teleport.exempt.cost")}, associatedPermissions={"nucleus.teleport.teleport.offline", "nucleus.teleport.teleport.quiet", "nucleus.teleport.teleport.others", "nucleus.teleport.tptoggle.exempt"})
public class TeleportCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private final String playerToKey = "Player to warp to";
    private final String quietKey = "quiet";
    private boolean isDefaultQuiet = false;

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.isDefaultQuiet = serviceCollection.moduleDataProvider().getModuleConfig(TeleportConfig.class).isDefaultQuiet();
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"f"}).setAnchorFlags(true).valueFlag((CommandElement)serviceCollection.commandElementSupplier().createPermissionParameter(GenericArguments.bool((Text)Text.of((String)this.quietKey)), "nucleus.teleport.teleport.quiet", false), new String[]{"q"}).buildWith(GenericArguments.none()), new AlternativeUsageArgument(GenericArguments.seq((CommandElement[])new CommandElement[]{IfConditionElseArgument.permission(serviceCollection.permissionService(), "nucleus.teleport.teleport.offline", NucleusParameters.ONE_USER_PLAYER_KEY.get(serviceCollection), NucleusParameters.ONE_PLAYER.get(serviceCollection)), new IfConditionElseArgument(serviceCollection.permissionService(), GenericArguments.optionalWeak((CommandElement)new SelectorArgument(new DisplayNameArgument((Text)Text.of((String)this.playerToKey), DisplayNameArgument.Target.PLAYER, serviceCollection), Player.class, serviceCollection)), GenericArguments.none(), this::testForSecondPlayer)}), src -> {
            StringBuilder sb = new StringBuilder();
            sb.append("<player to warp to>");
            if (serviceCollection.permissionService().hasPermission((Subject)src, "nucleus.teleport.teleport.others")) {
                sb.append("|<player to warp> <player to warp to>");
            }
            if (serviceCollection.permissionService().hasPermission((Subject)src, "nucleus.teleport.teleport.offline")) {
                sb.append("|<offline player to warp to>");
            }
            return Text.of((String)sb.toString());
        })};
    }

    private boolean testForSecondPlayer(IPermissionService permissionService, CommandSource source, CommandContext context) {
        try {
            if (context.hasAny("player") && permissionService.hasPermission((Subject)source, "nucleus.teleport.teleport.others")) {
                return context.getOne("player").map(y -> y.getPlayer().isPresent()).orElse(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Optional<ICommandResult> preExecute(ICommandContext.Mutable<? extends CommandSource> context) throws CommandException {
        return context.getServiceCollection().getServiceUnchecked(PlayerTeleporterService.class).canTeleportTo((CommandSource)context.getIfPlayer(), (User)context.requireOne("player", Player.class)) ? Optional.empty() : Optional.of(context.failResult());
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User to;
        Player from;
        User fromUser;
        boolean beQuiet = context.getOne(this.quietKey, Boolean.class).orElse(this.isDefaultQuiet);
        Optional<Player> oTo = context.getOne(this.playerToKey, Player.class);
        if (oTo.isPresent()) {
            fromUser = context.requireOne("player", User.class);
            from = fromUser.getPlayer().orElse(null);
            to = (User)oTo.get();
            if (context.is(to)) {
                return context.errorResult("command.teleport.player.noself", new Object[0]);
            }
        } else if (context.is(Player.class)) {
            from = context.getIfPlayer();
            fromUser = from;
            to = (User)context.requireOne("player", Player.class);
        } else {
            return context.errorResult("command.playeronly", new Object[0]);
        }
        if (from != null && to.getPlayer().isPresent()) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause((Object)context.getIfPlayer());
                TeleportResult result = context.getServiceCollection().getServiceUnchecked(PlayerTeleporterService.class).teleportWithMessage((CommandSource)context.getIfPlayer(), from, (Player)to.getPlayer().get(), !context.hasAny("f"), false, beQuiet);
                ICommandResult iCommandResult = result.isSuccessful() ? context.successResult() : context.failResult();
                return iCommandResult;
            }
        }
        if (!context.testPermission("nucleus.teleport.teleport.offline")) {
            return context.errorResult("command.teleport.noofflineperms", new Object[0]);
        }
        Supplier<CommandException> r = () -> context.createException("command.teleport.nolastknown", to.getName());
        if (from == null) {
            if (fromUser.setLocation(to.getPosition(), to.getUniqueId())) {
                context.sendMessage("command.teleport.offline.other", fromUser.getName(), to.getName());
                return context.successResult();
            }
        } else {
            World w = (World)to.getWorldUniqueId().flatMap(x -> Sponge.getServer().getWorld(x)).orElseThrow(r);
            Location l = new Location((Extent)w, to.getPosition());
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause((Object)context.getIfPlayer());
                boolean result = context.getServiceCollection().teleportService().teleportPlayerSmart(from, (Location<World>)l, false, !context.hasAny("f"), TeleportScanners.NO_SCAN.get()).isSuccessful();
                if (result) {
                    if (!context.is(from)) {
                        context.sendMessage("command.teleport.offline.other", from.getName(), to.getName());
                    }
                    context.sendMessage("command.teleport.offline.self", to.getName());
                    ICommandResult iCommandResult = context.successResult();
                    return iCommandResult;
                }
            }
        }
        return context.errorResult("command.teleport.error", new Object[0]);
    }
}

