/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.teleport.commands;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportResult;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanners;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.INucleusTeleportService;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.CommandFlags;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@EssentialsEquivalent(value={"tppos"})
@Command(aliases={"tppos"}, basePermission={"nucleus.teleport.tppos.base"}, commandDescriptionKey="tppos", associatedPermissions={"nucleus.teleport.tppos.exempt.bordercheck", "nucleus.teleport.tppos.others"})
public class TeleportPositionCommand
implements ICommandExecutor<CommandSource> {
    private final String location = "world";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().setUnknownShortFlagBehavior(CommandFlags.UnknownFlagBehavior.IGNORE).flag(new String[]{"f", "-force"}).flag(new String[]{"c", "-chunk"}).permissionFlag("nucleus.teleport.tppos.exempt.bordercheck", new String[]{"b", "-border"}).buildWith(GenericArguments.seq((CommandElement[])new CommandElement[]{serviceCollection.commandElementSupplier().createOtherUserPermissionElement(true, "nucleus.teleport.tppos.others"), GenericArguments.onlyOne((CommandElement)GenericArguments.optionalWeak((CommandElement)GenericArguments.world((Text)Text.of((String)this.location)))), NucleusParameters.POSITION}))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Player pl = context.getPlayerFromArgs();
        WorldProperties wp = context.getOne(this.location, WorldProperties.class).orElseGet(() -> pl.getWorld().getProperties());
        World world = (World)Sponge.getServer().loadWorld(wp.getUniqueId()).get();
        Vector3d location = context.requireOne("x y z", Vector3d.class);
        double xx = location.getX();
        double zz = location.getZ();
        double yy = location.getY();
        if (yy < 0.0) {
            return context.errorResult("command.tppos.ysmall", new Object[0]);
        }
        if (context.hasAny("c")) {
            xx = xx * 16.0 + 8.0;
            yy = yy * 16.0 + 8.0;
            zz = zz * 16.0 + 8.0;
            context.sendMessage("command.tppos.fromchunk", xx, yy, zz);
        }
        Vector3i max = world.getBlockMax();
        Vector3i min = world.getBlockMin();
        if (!(this.isBetween(xx, max.getX(), min.getX()) && this.isBetween(yy, max.getY(), min.getY()) && this.isBetween(zz, max.getZ(), min.getZ()))) {
            return context.errorResult("command.tppos.invalid", new Object[0]);
        }
        Location loc = new Location((Extent)world, xx, yy, zz);
        INucleusTeleportService teleportHandler = context.getServiceCollection().teleportService();
        boolean safe = context.getOne("f", Boolean.class).orElse(false);
        boolean border = context.hasAny("b");
        try (INucleusTeleportService.BorderDisableSession ac = teleportHandler.temporarilyDisableBorder(!safe && border, (World)loc.getExtent());){
            TeleportResult result = teleportHandler.teleportPlayerSmart(pl, (Location<World>)loc, false, safe, TeleportScanners.NO_SCAN.get());
            if (result.isSuccessful()) {
                context.sendMessageTo((MessageReceiver)pl, "command.tppos.success.self", new Object[0]);
                if (!context.is(pl)) {
                    context.sendMessage("command.tppos.success.other", pl.getName());
                }
                ICommandResult iCommandResult = context.successResult();
                return iCommandResult;
            }
            if (result == TeleportResult.FAIL_NO_LOCATION) {
                ICommandResult iCommandResult = context.errorResult("command.tppos.nosafe", new Object[0]);
                return iCommandResult;
            }
            ICommandResult iCommandResult = context.errorResult("command.tppos.cancelledevent", new Object[0]);
            return iCommandResult;
        }
    }

    private boolean isBetween(double toCheck, double max, double min) {
        return toCheck >= min && toCheck <= max;
    }
}

