/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.teleport.services;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportResult;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanners;
import io.github.nucleuspowered.nucleus.modules.teleport.config.TeleportConfig;
import io.github.nucleuspowered.nucleus.modules.teleport.services.TeleportRequest;
import io.github.nucleuspowered.nucleus.scaffold.service.ServiceBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.userprefs.NucleusKeysProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.INucleusTeleportService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.IUserPreferenceService;
import io.github.nucleuspowered.nucleus.services.interfaces.IWarmupService;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.world.World;

public class PlayerTeleporterService
implements ServiceBase,
IReloadableService.Reloadable {
    private boolean showAcceptDeny = true;
    private final INucleusServiceCollection serviceCollection;
    private final INucleusTeleportService safeTeleportService;
    private final IMessageProviderService messageProviderService;
    private final IUserPreferenceService userPreferenceService;
    private final IPermissionService permissionService;
    private final IWarmupService warmupService;
    private boolean refundOnDeny = false;
    private boolean useRequestLocation = true;
    private boolean useCommandsOnClickAcceptDeny = false;
    private boolean isOnlySameDimension = false;
    private final Map<UUID, TeleportRequest> activeTeleportRequestsCommand = new HashMap<UUID, TeleportRequest>();
    private final Multimap<UUID, TeleportRequest> activeTeleportRequests = HashMultimap.create();

    @Inject
    public PlayerTeleporterService(INucleusServiceCollection serviceCollection) {
        this.safeTeleportService = serviceCollection.teleportService();
        this.messageProviderService = serviceCollection.messageProvider();
        this.userPreferenceService = serviceCollection.userPreferenceService();
        this.permissionService = serviceCollection.permissionService();
        this.warmupService = serviceCollection.warmupService();
        this.serviceCollection = serviceCollection;
    }

    public boolean canTeleportTo(CommandSource source, User to) {
        if (source instanceof Player && !this.canBypassTpToggle((Subject)source) && !this.userPreferenceService.get(to.getUniqueId(), NucleusKeysProvider.TELEPORT_TARGETABLE).orElse(true).booleanValue()) {
            this.messageProviderService.sendMessageTo(source, "teleport.fail.targettoggle", to.getName());
            return false;
        }
        if (this.isOnlySameDimension && source instanceof Player && !to.getWorldUniqueId().map(x -> ((Player)source).getWorld().getUniqueId().equals(x)).orElse(false).booleanValue() && !this.permissionService.hasPermission((Subject)source, "nucleus.teleport.exempt.samedimension")) {
            this.messageProviderService.sendMessageTo(source, "teleport.fail.samedimension", to.getName());
            return false;
        }
        return true;
    }

    private boolean canBypassTpToggle(Subject from) {
        return this.permissionService.hasPermission(from, "nucleus.teleport.tptoggle.exempt");
    }

    public TeleportResult teleportWithMessage(CommandSource source, Player playerToTeleport, Player target, boolean safe, boolean quietSource, boolean quietTarget) {
        TeleportResult result = this.safeTeleportService.teleportPlayerSmart(playerToTeleport, (Transform<World>)target.getTransform(), false, safe, TeleportScanners.NO_SCAN.get());
        if (result.isSuccessful()) {
            if (!source.equals(target) && !quietSource) {
                this.messageProviderService.sendMessageTo(source, "teleport.success.source", playerToTeleport.getName(), target.getName());
            }
            this.messageProviderService.sendMessageTo((CommandSource)playerToTeleport, "teleport.to.success", target.getName());
            if (!quietTarget) {
                this.messageProviderService.sendMessageTo((CommandSource)target, "teleport.from.success", playerToTeleport.getName());
            }
        } else if (!quietSource) {
            this.messageProviderService.sendMessageTo(source, result == TeleportResult.FAIL_NO_LOCATION ? "teleport.nosafe" : "teleport.cancelled");
        }
        return result;
    }

    public boolean requestTeleport(@Nullable Player requester, Player toRequest, double cost, int warmup, Player playerToTeleport, Player target, boolean safe, boolean silentTarget, boolean silentSource, @Nullable Consumer<Player> successCallback, String messageKey) {
        this.removeExpired();
        if (this.canTeleportTo((CommandSource)playerToTeleport, (User)target)) {
            Player src = requester == null ? Sponge.getServer().getConsole() : requester;
            TeleportRequest request = new TeleportRequest(this.serviceCollection, playerToTeleport.getUniqueId(), target.getUniqueId(), Instant.now().plus(30L, ChronoUnit.SECONDS), this.refundOnDeny ? cost : 0.0, warmup, requester == null ? null : requester.getUniqueId(), safe, silentTarget, silentSource, (Transform<World>)(this.useRequestLocation ? target.getTransform() : null), successCallback);
            this.activeTeleportRequestsCommand.put(toRequest.getUniqueId(), request);
            this.activeTeleportRequests.put((Object)toRequest.getUniqueId(), (Object)request);
            this.messageProviderService.sendMessageTo((CommandSource)toRequest, messageKey, src.getName());
            this.getAcceptDenyMessage(toRequest, request).ifPresent(arg_0 -> ((Player)toRequest).sendMessage(arg_0));
            if (!silentSource) {
                this.messageProviderService.sendMessageTo((CommandSource)src, "command.tpask.sent", toRequest.getName());
            }
            return true;
        }
        return false;
    }

    public Optional<TeleportRequest> getCurrentRequest(Player player) {
        return Optional.ofNullable(this.activeTeleportRequestsCommand.get(player.getUniqueId()));
    }

    public void removeRequestsFor(Player player) {
        this.activeTeleportRequests.removeAll((Object)player.getUniqueId()).forEach(x -> x.forceExpire(true));
        this.activeTeleportRequestsCommand.remove(player.getUniqueId());
    }

    public void removeExpired() {
        this.activeTeleportRequests.values().removeIf(x -> !x.isActive());
        this.activeTeleportRequestsCommand.values().removeIf(x -> !x.isActive());
    }

    private Optional<Text> getAcceptDenyMessage(Player forPlayer, TeleportRequest target) {
        if (this.showAcceptDeny) {
            Text acceptText = this.messageProviderService.getMessageFor(forPlayer.getLocale(), "standard.accept").toBuilder().style(new TextStyle[]{TextStyles.UNDERLINE}).onHover((HoverAction)TextActions.showText((Text)this.messageProviderService.getMessageFor(forPlayer.getLocale(), "teleport.accept.hover"))).onClick((ClickAction)TextActions.executeCallback(src -> {
                if (!(target.isActive() && this.permissionService.hasPermission((Subject)src, "nucleus.teleport.tpaccept.base") && src instanceof Player)) {
                    this.messageProviderService.sendMessageTo((CommandSource)src, "command.tpaccept.nothing");
                    return;
                }
                if (this.useCommandsOnClickAcceptDeny) {
                    Sponge.getCommandManager().process(src, "nucleus:tpaccept");
                } else {
                    this.accept((Player)src, target);
                }
            })).build();
            Text denyText = this.messageProviderService.getMessageFor(forPlayer.getLocale(), "standard.deny").toBuilder().style(new TextStyle[]{TextStyles.UNDERLINE}).onHover((HoverAction)TextActions.showText((Text)this.messageProviderService.getMessageFor(forPlayer.getLocale(), "teleport.deny.hover"))).onClick((ClickAction)TextActions.executeCallback(src -> {
                if (!(target.isActive() && this.permissionService.hasPermission((Subject)src, "nucleus.teleport.tpdeny.base") && src instanceof Player)) {
                    this.messageProviderService.sendMessageTo((CommandSource)src, "command.tpdeny.fail");
                    return;
                }
                if (this.useCommandsOnClickAcceptDeny) {
                    Sponge.getCommandManager().process(src, "nucleus:tpdeny");
                } else {
                    this.deny((Player)src, target);
                }
            })).build();
            return Optional.of(Text.builder().append(new Text[]{acceptText}).append(new Text[]{Text.of((String)" - ")}).append(new Text[]{denyText}).build());
        }
        return Optional.empty();
    }

    public boolean accept(Player player) {
        return this.accept(player, this.getCurrentRequest(player).orElse(null));
    }

    private boolean accept(Player player, @Nullable TeleportRequest target) {
        if (target == null) {
            this.messageProviderService.sendMessageTo((CommandSource)player, "command.tpaccept.nothing");
            return false;
        }
        if (!target.isActive()) {
            this.messageProviderService.sendMessageTo((CommandSource)player, "command.tpaccept.expired");
            return false;
        }
        this.activeTeleportRequests.values().remove(target);
        this.activeTeleportRequestsCommand.values().remove(target);
        target.forceExpire(false);
        Optional<Player> playerToTeleport = target.getToBeTeleported();
        if (!playerToTeleport.isPresent()) {
            this.messageProviderService.sendMessageTo((CommandSource)player, "command.tpaccept.noplayer");
            return false;
        }
        if (target.warmup == 0) {
            target.run();
        } else {
            this.warmupService.executeAfter(playerToTeleport.get(), Duration.of(target.warmup, ChronoUnit.SECONDS), target::run, true);
        }
        this.messageProviderService.sendMessageTo((CommandSource)player, "command.tpaccept.success");
        return true;
    }

    public boolean deny(Player player) {
        return this.deny(player, this.getCurrentRequest(player).orElse(null));
    }

    private boolean deny(Player player, @Nullable TeleportRequest target) {
        if (target == null) {
            this.messageProviderService.sendMessageTo((CommandSource)player, "command.tpaccept.nothing");
            return false;
        }
        if (!target.isActive()) {
            this.messageProviderService.sendMessageTo((CommandSource)player, "command.tpaccept.expired");
            return false;
        }
        target.forceExpire(true);
        this.activeTeleportRequests.values().remove(target);
        this.activeTeleportRequestsCommand.values().remove(target);
        this.messageProviderService.sendMessageTo((CommandSource)player, "command.tpdeny.deny");
        return true;
    }

    static void onCancel(INucleusServiceCollection serviceCollection, UUID requester, UUID toTeleport, double cost) {
        Text name = serviceCollection.playerDisplayNameService().getDisplayName(toTeleport);
        if (requester == null) {
            serviceCollection.messageProvider().sendMessageTo((CommandSource)Sponge.getServer().getConsole(), "command.tpdeny.denyrequester", name);
        } else {
            Optional op = Sponge.getServer().getPlayer(requester);
            op.ifPresent(x -> serviceCollection.messageProvider().sendMessageTo((CommandSource)x, "command.tpdeny.denyrequester", name));
            if (serviceCollection.economyServiceProvider().serviceExists() && cost > 0.0) {
                op.ifPresent(x -> serviceCollection.messageProvider().sendMessageTo((CommandSource)x, "teleport.prep.cancel", serviceCollection.economyServiceProvider().getCurrencySymbol(cost)));
                User user = op.map(x -> x).orElseGet(() -> ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(requester).orElse(null));
                if (user != null) {
                    serviceCollection.economyServiceProvider().depositInPlayer(user, cost);
                }
            }
        }
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        TeleportConfig config = serviceCollection.moduleDataProvider().getModuleConfig(TeleportConfig.class);
        this.useCommandsOnClickAcceptDeny = config.isUseCommandsOnClickAcceptOrDeny();
        this.showAcceptDeny = config.isShowClickableAcceptDeny();
        this.refundOnDeny = config.isRefundOnDeny();
        this.useRequestLocation = config.isUseRequestLocation();
        this.isOnlySameDimension = config.isOnlySameDimension();
    }
}

