/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.commands;

import io.github.nucleuspowered.nucleus.api.module.warp.data.Warp;
import io.github.nucleuspowered.nucleus.modules.warp.commands.WarpCommand;
import io.github.nucleuspowered.nucleus.modules.warp.services.WarpService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"setdescription"}, basePermission={"nucleus.warp.setdescription.base"}, commandDescriptionKey="warp.setdescription", async=true, parentCommand=WarpCommand.class)
public class SetDescriptionCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"r", "-remove", "-delete"}).buildWith(GenericArguments.seq((CommandElement[])new CommandElement[]{serviceCollection.getServiceUnchecked(WarpService.class).warpElement(false), NucleusParameters.OPTIONAL_DESCRIPTION}))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        WarpService handler = context.getServiceCollection().getServiceUnchecked(WarpService.class);
        String warpName = context.requireOne("warp", Warp.class).getName();
        if (context.hasAny("r")) {
            if (handler.setWarpDescription(warpName, null)) {
                context.sendMessage("command.warp.description.removed", warpName);
                return context.successResult();
            }
            return context.errorResult("command.warp.description.noremove", warpName);
        }
        Text message = TextSerializers.FORMATTING_CODE.deserialize(context.requireOne("description", String.class));
        if (handler.setWarpDescription(warpName, message)) {
            context.sendMessage("command.warp.description.added", message, Text.of((String)warpName));
            return context.successResult();
        }
        return context.errorResult("command.warp.description.couldnotadd", Text.of((String)warpName));
    }
}

