/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands.border;

import io.github.nucleuspowered.nucleus.modules.world.commands.border.BorderCommand;
import io.github.nucleuspowered.nucleus.modules.world.services.WorldHelper;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.BoundedIntegerArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.TimespanArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@Command(aliases={"gen", "genchunks", "generatechunks", "chunkgen"}, basePermission={"nucleus.world.border.gen.base"}, commandDescriptionKey="world.border.gen", parentCommand=BorderCommand.class, associatedPermissions={"nucleus.world.border.gen.notify"})
public class GenerateChunksCommand
implements ICommandExecutor<CommandSource> {
    private static final String ticksKey = "tickPercent";
    private static final String tickFrequency = "tickFrequency";
    private static final String saveTimeKey = "time between saves";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"a", "-aggressive"}).flag(new String[]{"u", "-ultra-aggressive"}).flag(new String[]{"r", "-restart"}).valueFlag((CommandElement)new TimespanArgument((Text)Text.of((String)saveTimeKey), serviceCollection), new String[]{"-save"}).valueFlag((CommandElement)new BoundedIntegerArgument((Text)Text.of((String)ticksKey), 0, 100, serviceCollection), new String[]{"t", "-tickpercent"}).valueFlag((CommandElement)new BoundedIntegerArgument((Text)Text.of((String)tickFrequency), 1, 100, serviceCollection), new String[]{"f", "-frequency"}).buildWith(NucleusParameters.OPTIONAL_WORLD_PROPERTIES_ENABLED_ONLY.get(serviceCollection))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        WorldProperties wp = context.getWorldPropertiesOrFromSelf("world").orElseThrow(() -> context.createException("command.world.player", new Object[0]));
        WorldHelper worldHelper = context.getServiceCollection().getServiceUnchecked(WorldHelper.class);
        if (worldHelper.isPregenRunningForWorld(wp.getUniqueId())) {
            return context.errorResult("command.world.gen.alreadyrunning", wp.getWorldName());
        }
        int level = context.hasAny("u") ? 2 : (context.hasAny("a") ? 1 : 0);
        World w = (World)Sponge.getServer().getWorld(wp.getUniqueId()).orElseThrow(() -> context.createException("command.world.gen.notloaded", wp.getWorldName()));
        worldHelper.startPregenningForWorld(w, level, context.getOne(saveTimeKey, Long.class).orElseGet(() -> this.getDefaultSaveTime(level)) * 1000L, context.getOne(ticksKey, Integer.class).orElse(null), context.getOne(tickFrequency, Integer.class).orElse(null), context.hasAny("r"));
        context.sendMessage("command.world.gen.started", wp.getWorldName());
        return context.successResult();
    }

    private long getDefaultSaveTime(int aggressionLevel) {
        if (aggressionLevel == 2) {
            return 120L;
        }
        if (aggressionLevel == 1) {
            return 30L;
        }
        return 20L;
    }
}

