/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.scaffold.command.control;

import com.google.common.collect.ImmutableList;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CommandMetadata {
    private final String moduleid;
    private final String modulename;
    private final String metadataKey;
    private final Command annotation;
    private final Class<? extends ICommandExecutor<?>> executor;
    private final String commandKey;
    private final List<String> root;
    private final List<String> sub;
    private final List<String> disabledByDefault;
    private final boolean isRoot;
    private final boolean modifierKeyRedirect;
    private final @Nullable EssentialsEquivalent essentialsEquivalent;

    private static void aliases(String[] v, boolean isRoot, boolean addPrefix, ImmutableList.Builder<String> root, ImmutableList.Builder<String> sub, ImmutableList.Builder<String> disabled) {
        for (String alias : v) {
            if (alias.startsWith("#")) {
                root.add((Object)alias.substring(1).toLowerCase());
                if (!addPrefix) continue;
                root.add((Object)("n" + alias.substring(1).toLowerCase()));
                continue;
            }
            if (alias.startsWith("$")) {
                String x = alias.substring(1).toLowerCase();
                root.add((Object)x);
                disabled.add((Object)x);
                if (!addPrefix) continue;
                root.add((Object)("n" + x));
                continue;
            }
            if (isRoot) {
                root.add((Object)alias.toLowerCase());
                if (!addPrefix) continue;
                root.add((Object)("n" + alias.toLowerCase()));
                continue;
            }
            sub.add((Object)alias.toLowerCase());
        }
    }

    public CommandMetadata(String moduleid, String modulename, Command annotation, Class<? extends ICommandExecutor<?>> executor, String commandKey, @Nullable EssentialsEquivalent essentialsEquivalent) {
        this.moduleid = moduleid;
        this.modulename = modulename;
        this.annotation = annotation;
        this.executor = executor;
        this.commandKey = commandKey;
        ImmutableList.Builder rootBuilder = new ImmutableList.Builder();
        ImmutableList.Builder subBuilder = new ImmutableList.Builder();
        ImmutableList.Builder disabledRootBuilder = new ImmutableList.Builder();
        CommandMetadata.aliases(annotation.aliases(), annotation.parentCommand() == ICommandExecutor.class, annotation.prefixAliasesWithN(), (ImmutableList.Builder<String>)rootBuilder, (ImmutableList.Builder<String>)subBuilder, (ImmutableList.Builder<String>)disabledRootBuilder);
        this.root = rootBuilder.build();
        this.sub = subBuilder.build();
        this.disabledByDefault = disabledRootBuilder.build();
        this.isRoot = annotation.parentCommand() == ICommandExecutor.class;
        this.essentialsEquivalent = essentialsEquivalent;
        this.modifierKeyRedirect = !annotation.modifierOverride().isEmpty();
        this.metadataKey = this.modifierKeyRedirect ? annotation.modifierOverride() : this.commandKey;
    }

    public String getModuleid() {
        return this.moduleid;
    }

    public String getModulename() {
        return this.modulename;
    }

    public Command getCommandAnnotation() {
        return this.annotation;
    }

    public String getCommandKey() {
        return this.commandKey;
    }

    public String[] getAliases() {
        return this.annotation.aliases();
    }

    public List<String> getRootAliases() {
        return this.root;
    }

    public List<String> getDisabledByDefaultRootAliases() {
        return this.disabledByDefault;
    }

    public List<String> getAtLevelAliases() {
        return this.sub;
    }

    public Class<? extends ICommandExecutor<?>> getExecutor() {
        return this.executor;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public String getMetadataKey() {
        return this.metadataKey;
    }

    public boolean isModifierKeyRedirect() {
        return this.modifierKeyRedirect;
    }

    public @Nullable EssentialsEquivalent getEssentialsEquivalent() {
        return this.essentialsEquivalent;
    }
}

