/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.scaffold.command.modifier.impl;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.control.CommandControl;
import io.github.nucleuspowered.nucleus.scaffold.command.modifier.ICommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public class RequiresEconomyModifier
implements ICommandModifier,
IReloadableService.Reloadable {
    private @Nullable Text lazyLoad = null;

    public String getId() {
        return "nucleus:requires_economy";
    }

    public String getName() {
        return "Requires Economy Modifier";
    }

    @Override
    public Optional<Text> testRequirement(ICommandContext.Mutable<? extends CommandSource> source, CommandControl control, INucleusServiceCollection serviceCollection, CommandModifier modifier) throws CommandException {
        if (!serviceCollection.economyServiceProvider().serviceExists()) {
            if (this.lazyLoad == null) {
                this.lazyLoad = serviceCollection.messageProvider().getMessageFor((CommandSource)source.getCommandSource(), "command.economyrequired");
            }
            return Optional.of(this.lazyLoad);
        }
        return Optional.empty();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.lazyLoad = null;
    }
}

